#include <CAVERN.hxx>

void parseCommandLine(int argc,char **argv);


int portNumber = CAVERNnet_remoteFileIOServer32_c::DEFAULT_PORT;
char * linkHost = NULL;


int main(int argc, char** argv)
	{
	CAVERNinit();

	CAVERNnet_remoteFileIOServer32_c server;
	server.init(portNumber,linkHost);

	while (true)
		{
		server.process(CAVERNnet_remoteFileIOServer32_c::THREADED);
		usleep(1000);
		}
	}


void parseCommandLine(int argc,char **argv)
	{
	int i;
	for (i=1; i < argc; i++)
		{
		if (!strncmp(argv[i],"--",2))
			{
			if (!strcasecmp(argv[i],"--link"))
				{
				i++;
				linkHost = strdup(argv[i]);
				}
			else if (!strcasecmp(argv[i],"--port"))
				{
				i++;
				portNumber = atoi(argv[i]);
				}
			else
				fprintf(stderr,"WARNING: unknown command line "
					"option '%s'\n",argv[i]);
			}
		}
	}
