#include <stdlib.h>
#include <stdio.h>
#include <unistd.h>
#include <ctype.h>
#include <sys/time.h>
#include <netinet/in.h>
#include <time.h>
#include <map>
#include <CAVERN.hxx>
#include "ygString.h"
#include "ygNetClient.h"

using namespace std;


class ygNetClientKey
	{
	public:
	 void *data;
	 size_t size;
	 size_t bufferSize;
	 bool owned;
	};

typedef map<ygString,ygNetClientKey *> ygNetClientKeymap;
typedef map<ygString,ygNetClientKeymap> ygNetClientPathmap;


struct _ygNetClientPrivateData
	{
	ygNetClientPathmap paths;
	CAVERNnet_datapack_c packer;
	void * packetBuffer;
	int numKeys;
	} *p_;

void downloadViaTCP(const ygString& server,int port,bool verbose);
void initPacker(size_t s);
void processKeyData(ygString& path,ygString& key);
ygNetClientKey * getKeyStruct(const ygString& path, const ygString& key,bool owned);
void printContents(void);



int main(int argc,char **argv)
	{
	ygString server("localhost");
	int cachePort=3501, hostArg=1;
	bool verbose = false;
	p_ = new struct _ygNetClientPrivateData;
	p_->packetBuffer = malloc(YG_NET_MAX_BUFFER_SIZE);
	p_->numKeys = 0;
	if ((argc > 1) && (strcmp(argv[1],"-v") == 0))
		{
		verbose = true;
		hostArg++;
		}
	if (argc > hostArg)
		server = argv[hostArg];
	if (argc > hostArg+1)
		cachePort = atoi(argv[hostArg+1]);
	downloadViaTCP(server,cachePort,verbose);
	printContents();
	return 0;
	}


void downloadViaTCP(const ygString& server,int port,bool verbose)
	{
	cout << "downloadViaTCP: connecting to " << server << ":" << port << endl;
	CAVERNnet_tcpReflectorClient_c *sock = new CAVERNnet_tcpReflectorClient_c;
	if (sock->connectToServer(server.c_str(),port) ==
			CAVERNnet_tcpReflectorClient_c::FAILED)
		{
		cerr << "ERROR: downloadViaTCP: failed to connect"
			" to cache server " << server << ":" << port << endl;
		return;
		}
	int nbytes;
	initPacker(sizeof(int));
	p_->packer.packInt(YG_NET_REQUEST_ALL);
	nbytes = p_->packer.getBufferFilledSize();
	sock->write(p_->packer.getBuffer(),&nbytes);
	time_t startTime = time(NULL);
	char * buf = NULL;
	if (sock->read(&buf, &nbytes, CAVERNnet_tcpReflectorClient_c::BLOCKING)
				!= CAVERNnet_tcpReflectorClient_c::OK)
		cerr << "ERROR: downloadViaTCP: socket read failed\n";
	else
		{
		p_->packer.initUnpack(buf,nbytes);
		time_t totalTime = time(NULL) - startTime;
		while (true)
			{
			int packetType = -1;
			p_->packer.unpackInt(&packetType);
			if (packetType == YG_NET_DOWNLOAD_DONE)
				break;
			else if (packetType == YG_NET_PUT_KEY)
				{
				ygString path, key;
				processKeyData(path,key);
				if (verbose)
					cout << "got key " << path << "/" << key << endl << flush;
				}
			}
		printf("downloadViaTCP: downloaded %d keys (%d bytes) in %d seconds\n",
			p_->numKeys, nbytes, totalTime);
		}
	if (buf)
		delete buf;
	sock->close();
	}


void initPacker(size_t s)
	{
	if (s > YG_NET_MAX_BUFFER_SIZE)
		{
		cerr << "ERROR: initPacker(): trying to set buffer "
			"size to " << s << " bytes; maximum is " <<
			YG_NET_MAX_BUFFER_SIZE << endl;
		s = YG_NET_MAX_BUFFER_SIZE;
		}
	p_->packer.initPack((char*)p_->packetBuffer, s);	
	}


void processKeyData(ygString& path,ygString& key)
	{
	int length;
	char *tmpstr;
/* Get path string length & data */
	p_->packer.unpackInt(&length);
	tmpstr = (char *) malloc(length);
	p_->packer.unpack(tmpstr, length);
	path.clear();
	path.append(tmpstr);
	free(tmpstr);
/* Get key string length & data */
	p_->packer.unpackInt(&length);
	tmpstr = (char *) malloc(length);
	p_->packer.unpack(tmpstr, length);
	key.clear();
	key.append(tmpstr);
	free(tmpstr);
/* Get data length & data */
	p_->packer.unpackInt(&length);
	ygNetClientKey * keystruct = getKeyStruct(path,key,false);
	if (keystruct)
		{
		if (length > keystruct->bufferSize)
			{
			keystruct->bufferSize = length;
			keystruct->data = realloc(keystruct->data,keystruct->bufferSize);
			}
		p_->packer.unpack((char *)keystruct->data, length);
		keystruct->size = length;
		}
	}


ygNetClientKey * getKeyStruct(const ygString& path, const ygString& key,bool owned)
	{
	ygNetClientKey * keystruct = p_->paths[path][key];
	if (!keystruct)
		{
		keystruct = new ygNetClientKey;
		keystruct->data = NULL;
		keystruct->size = 0;
		keystruct->bufferSize = 0;
		keystruct->owned = owned;
		p_->paths[path][key] = keystruct;
		p_->numKeys++;
		}
	return keystruct;
	}


void printKey(const ygString& name,void *data,int size)
	{
	CAVERNnet_datapack_c packer;
	if ((name == "type") || (name == "children") || (name == "file") ||
	    (name == "volume") || (name == "message"))
		{
		printf("'%s'",(char*)data);
		}
	else if (name == "m")
		{
		int i,j;
		float val;
		packer.initUnpack((char*) data, size);
		for (i=0; i<4; i++)
			for (j=0; j<4; j++)
				{
				packer.unpackFloat(&val);
				printf("%.2f ",val);
				}
		}
	else if (name == "x")
		{
		float val[3];
		packer.initUnpack((char*) data, size);
		packer.unpackFloatArray(val,3);
		printf("xyz(%.2f %.2f %.2f) ",val[0],val[1],val[2]);
		packer.unpackFloatArray(val,3);
		printf("hpr(%.2f %.2f %.2f)",val[0],val[1],val[2]);
		}
	else if (name == "on")
		{
		printf("'%c'",*((char*)data));
		}
	}


void printContents(void)
	{
	printf("\nDatabase contents:\n");
	ygNetClientPathmap::const_iterator iter;
	for (iter = p_->paths.begin(); iter != p_->paths.end(); ++iter)
		{
		ygNetClientKeymap::const_iterator iter2;
		for (iter2 = iter->second.begin(); iter2 != iter->second.end(); ++iter2)
			{
			printf("  %s/%s - %d bytes\t", 
				iter->first.c_str(), iter2->first.c_str(),
				iter2->second->size);
			printKey(iter2->first,iter2->second->data,iter2->second->size);
			printf("\n");
			}
		}
	}
