#include <stdlib.h>
#include <stdio.h>
#include <map>
#include <CAVERN.hxx>
#include "ygNetClient.h"
#include "ygKeyDatabase.h"

using namespace std;



class ygKeyDatabaseKey
	{
	public:
	 void *data;
	 size_t size;
	 size_t bufferSize;
	 int updates;
	};

typedef map<ygString,ygKeyDatabaseKey *> ygKeyDatabaseKeymap;
typedef map<ygString,ygKeyDatabaseKeymap> ygKeyDatabasePathmap;


struct _ygKeyDatabasePrivateData
	{
	ygKeyDatabasePathmap paths;
	CAVERNts_mutex_c mapMutex;
	int totalUpdates, numKeys;
	};



ygKeyDatabase::ygKeyDatabase(void)
	{
	p_ = new struct _ygKeyDatabasePrivateData;
	p_->totalUpdates = 0;
	p_->numKeys = 0;
	}



void * ygKeyDatabase::get(const ygString& path,const ygString& key,size_t *size)
	{
	p_->mapMutex.lock();
	ygKeyDatabaseKey * keystruct = p_->paths[path][key];
	if (!keystruct)
		{
		p_->mapMutex.unlock();
		if (size)
			*size = 0;
		return NULL;
		}
	else
		{
		void * retData = malloc(keystruct->size);
		if (size)
			*size = keystruct->size;
		memcpy(retData,keystruct->data,keystruct->size);
		p_->mapMutex.unlock();
		return retData;
		}
	}


void ygKeyDatabase::store(const ygString& path, const ygString& key, void *data, size_t size)
	{
	p_->mapMutex.lock();
	ygKeyDatabaseKey * keystruct = p_->paths[path][key];
	if (!keystruct)
		{
		keystruct = new ygKeyDatabaseKey;
		keystruct->data = NULL;
		keystruct->size = 0;
		keystruct->bufferSize = 0;
		keystruct->updates = 0;
		p_->paths[path][key] = keystruct;
		p_->numKeys++;
		}
	if (!keystruct->data)
		{
		keystruct->bufferSize = size;
		keystruct->data = malloc(keystruct->bufferSize);
		}
	else if (size > keystruct->bufferSize)
		{
		keystruct->bufferSize = size;
		keystruct->data = realloc(keystruct->data,keystruct->bufferSize);
		}
	memcpy(keystruct->data,data,size);
	keystruct->size = size;
	keystruct->updates++;
	p_->mapMutex.unlock();
	p_->totalUpdates++;
	}


void ygKeyDatabase::printStats(void)
	{
	cout << "\nDatabase stats:" << p_->numKeys << " keys,  "
		<< p_->totalUpdates << " updates" << endl << flush;
	}


void ygKeyDatabase::printContents(FILE *fp)
	{
	if (!fp)
		return;
	fprintf(fp, "\nDatabase contents:\n");
	ygKeyDatabasePathmap::const_iterator iter;
	for (iter = p_->paths.begin(); iter != p_->paths.end(); ++iter)
		{
		ygKeyDatabaseKeymap::const_iterator iter2;
		for (iter2 = iter->second.begin(); iter2 != iter->second.end(); ++iter2)
			fprintf(fp, "  %s/%s - %d bytes, %d updates\n", 
				iter->first.c_str(), iter2->first.c_str(),
				iter2->second->size, iter2->second->updates);
		}
	fflush(fp);
	}


#if 0
void ygKeyDatabase::printContents(void)
	{
	cout << "\nDatabase contents:\n";
	ygKeyDatabasePathmap::const_iterator iter;
	for (iter = p_->paths.begin(); iter != p_->paths.end(); ++iter)
		{
		ygKeyDatabaseKeymap::const_iterator iter2;
		for (iter2 = iter->second.begin(); iter2 != iter->second.end(); ++iter2)
			cout << "  " << iter->first << "/" << iter2->first << " - " << iter2->second->size << " bytes  "
				<< iter2->second->updates << " updates\n";
		}
	cout << flush;
	}
#endif


static size_t keyPacketSize(const ygString& path, const ygString& key,
			ygKeyDatabaseKey *keystruct)
	{
	if (keystruct->size < 1)
		return 0;
	return sizeof(int) + 
		sizeof(int) + path.length()+1 +
		sizeof(int) + key.length()+1 +
		sizeof(int) + keystruct->size;
	}


void ygKeyDatabase::sendContents(CAVERNnet_tcpReflectorClient_c *client)
	{
	size_t bufferSize = 0;
	char * buffer;
	int count=0;
	CAVERNnet_datapack_c packer;
	ygKeyDatabasePathmap::const_iterator iter;
	for (iter = p_->paths.begin(); iter != p_->paths.end(); ++iter)
		{
		ygKeyDatabaseKeymap::const_iterator iter2;
		for (iter2 = iter->second.begin(); iter2 != iter->second.end(); ++iter2)
			bufferSize += keyPacketSize(iter->first, iter2->first,
							iter2->second);
		}
	bufferSize += sizeof(int);
	buffer = (char*)malloc(bufferSize);
	packer.initPack(buffer,bufferSize);
	for (iter = p_->paths.begin(); iter != p_->paths.end(); ++iter)
		{
		ygKeyDatabaseKeymap::const_iterator iter2;
		for (iter2 = iter->second.begin(); iter2 != iter->second.end(); ++iter2)
			{
			p_->mapMutex.lock();
			packKeyStruct(iter->first, iter2->first,
					iter2->second, &packer);
			p_->mapMutex.unlock();
			count++;
			if (count % 1000 == 0)
				{
				printf("ygKeyDatabase::sendContents: sent %d keys\n",count);
				fflush(stdout);
				}
			}
		}
	packer.packInt(YG_NET_DOWNLOAD_DONE);
	int totalSize = packer.getBufferFilledSize();
	client->write(packer.getBuffer(), &totalSize);
	free(buffer);
	}


void ygKeyDatabase::packKeyStruct(const ygString& path, const ygString& key,
			ygKeyDatabaseKey *keystruct,
			CAVERNnet_datapack_c *packer)
	{
	if (keystruct->size < 1)
		return;
	packer->packInt(YG_NET_PUT_KEY);
	packer->packInt(path.length()+1);
	packer->pack(path.c_str(), path.length()+1);
	packer->packInt(key.length()+1);
	packer->pack(key.c_str(), key.length()+1);
	packer->packInt(keystruct->size);
	packer->pack((char *)keystruct->data, keystruct->size);
	}
