#include <stdio.h>
#include "CAVERN.hxx"

#include <sys/time.h>

static struct timeval timing_start, timing_now;

void init_timing(void)
	{
	gettimeofday(&timing_start,NULL);
	}

#define GET_TIME_IN_MSECS(V) \
	{ gettimeofday(&timing_now,NULL); \
	  V = (timing_now.tv_usec - timing_start.tv_usec) / 1000 + \
	      (timing_now.tv_sec - timing_start.tv_sec) * 1000; }



#define SEND 0
#define KEY_PATH "foobar"
#define KEY_NAME "baz"

main(int argc,char **argv)
	{
	int numPacketsPerGroup = 1;
	int msecsPerGroup = 1;
	int lastTime, now, i;
	if (argc < 3)
		{
		fprintf(stderr,"Usage: %s repeater-host repeater-port [num-packets-per-group msecs-per-group]\n",argv[0]);
		exit(1);
		}
	if (argc > 3)
		numPacketsPerGroup = atoi(argv[3]);
	if (argc > 4)
		msecsPerGroup = atoi(argv[4]);
/* Create the data packet to spew */
	int nbytes;
	char data[16] = "1234567890abcde";
	CAVERNnet_datapack_c packer;
	void * buf = malloc(1024);
	packer.initPack((char *)buf, 1024);
	packer.packInt(SEND);
	packer.packInt(strlen(KEY_PATH)+1);
	packer.pack(KEY_PATH,strlen(KEY_PATH)+1);
	packer.packInt(strlen(KEY_NAME)+1);
	packer.pack(KEY_NAME,strlen(KEY_NAME)+1);
	packer.packInt(16);
	packer.pack(data,16);
	nbytes = packer.getBufferFilledSize();

/* Initialize the sockets */
	int port = atoi(argv[2]);
	CAVERNnet_udp_c * udpSocket;
	udpSocket = new CAVERNnet_udp_c;
	udpSocket->init(0);
	udpSocket->setSendAddress(argv[1],port);
	udpSocket->makeNonBlocking();

/* Sit & spew */
	init_timing();
	GET_TIME_IN_MSECS(lastTime)
	while (1)
		{
		for (i=0; i < numPacketsPerGroup; i++)
			udpSocket->send((char*)buf,nbytes);
		GET_TIME_IN_MSECS(now)
		while (now-lastTime < msecsPerGroup)
			{
			usleep(100);
			GET_TIME_IN_MSECS(now)
			}
		lastTime = now;
		}
	}
