// Description: an array that is read from a file
//
//<b>notes:</b>
//<ul>
//<li> derived nodes inherit all messages from their base classes
//<li> see reset method for default settings
//<li> see the <a href="value.html">value</a> node for more information
//</ul>
//
// Category: Math
// Author: Alex Hill
// Revision: 11/01/01
//
#include <ygUtil.h>
#include "writeFile.h"

extern "C" ygNode* construct_writeFile(const char* name,bool master) { return new writeFile(name,master); }

writeFile::writeFile(const char* name,bool master) : value(name,master)
	{
	setClassName("writeFile");
	fp = NULL;
	}

writeFile::~writeFile(void)
	{
	if (fp)
		fclose(fp);
	}

void writeFile::reset(void)
	{
	filename.clear();
	if (fp)
		fclose(fp);
	fp = NULL;
	value::reset();
	}
	
void writeFile::message(const ygMessage& msg)
	{
	//the name of file to write array values to
	if (msg == "file")
		{
		if (msg.args.size() > 0)
			{
			filename = msg.args[0];
			openFile(filename);
			}
		}
	//write out one value for each array element
	else if (msg == "write")
		{
		if (fp)
			{
			for (int i=0; i<size; i++)
				fprintf(fp,"%g ",values[i]);
			fprintf(fp,"\n");
			}
		}
	else
		value::message(msg);
	}
   
 
void writeFile::openFile(const ygString& file)
	{
	filename = file;
	if (fp)
		fclose(fp);
	if (file.length() > 0)
		{
		char *searchPath = ".";
		ygString fullPath;
		if (getenv("YG_PATH"))
			searchPath = getenv("YG_PATH");
		if (!ygFindFile(file,searchPath,fullPath))
			fullPath = file;
		fp = fopen(fullPath.c_str(),"w");
		if (!fp)
			fprintf(stderr,"ERROR: writeFile: could not open \"%s\"\n",fullPath.c_str());
		}
	else
		fp = NULL;
	}
