#ifndef _water_h_
#define _water_h_

#include "ygTransform.h"


class water : public ygTransform
{
public:
	enum _waterState { INITIAL, START, WAITING, MOVING };
	water(const char* name,bool master=true);
	~water(void);
	virtual void reset(void);
	virtual void message(const ygMessage&);
	virtual void app(void);

private:
	bool isWall_;
	bool isFloor_;
	_waterState state_;
	pfVec2 len_;
	pfVec4 color_;
	float speed_;
	float delay_;
	float phaseSpeed_;
	float rippleSize_;
	float rippleHeight_;
	float startTime_;
	float duration_;
	bool specularOn_;
	bool firstFrame_;

	pfGeoSet * gset_;
	pfGeode * createGeode(void);
};


#endif
