// Description: a space that generates events in the presence of a user and wand
//
//<b>notes:</b>
//<ul>
//<li> derived nodes inherit all messages from their base classes
//<li> see reset method for default settings
//<li> for volume messages refer to the <a href="ygSpace.html">ygSpace</a> node
//<li> this node requires the user have a <a href="ygCAVEWand.html">ygCAVEWand</a> node
//<li> all wand events are also generated by this node (ex. button1)
//</ul>
//
// Category: Trigger
// Author: Dave Pape
// Revision: 11/01/01
//
#include <ygUser.h>
#include <ygWand.h>
#include <ygUtil.h>
#include <ygWorld.h>
#include <vector>
#include "wandTrigger.h"

using namespace std;

extern "C" ygNode* construct_wandTrigger(const char* name,bool master) { return new wandTrigger(name,master); }

struct _wandTriggerPrivateData
	{
	vector<ygWand*> prevInside;
	vector<ygUser*> prevInsideUser;
	int lastFrame;
	};


wandTrigger::wandTrigger(const char* name,bool master) : ygSpace(name,master)
	{
	setClassName("wandTrigger");
	p_ = new struct _wandTriggerPrivateData;
	p_->lastFrame = 0;
	}

wandTrigger::~wandTrigger(void)
	{
	delete p_;
	}


void wandTrigger::reset(void)
	{
	//clear set of users previously inside
	p_->prevInside.clear();
	p_->prevInsideUser.clear();
	p_->lastFrame = ygWorld::FrameNumber;
	ygSpace::reset();
	}


void wandTrigger::app(void)
	{
	vector<ygWand*> inside;
	vector<ygUser*> insideUser;
	int i,j,f;
	if (p_->lastFrame < (ygWorld::FrameNumber-1))
		{
		p_->prevInside.clear();
		p_->prevInsideUser.clear();
		}
	p_->lastFrame = ygWorld::FrameNumber;
	//for each user in the world
	for (i=0; i < ygWorld::World->numUsers(); i++)
		{
		ygUser * user = ygWorld::World->user(i);
		//for each associated wand
		for (j=0; j < user->numWands(); j++)
			{
			if (user->wand(j) && user->wand(j)->isOfClass("ygWand"))
				{
				ygWand * wand = (ygWand*) (user->wand(j));
				//if wand is within the space
				if ((wand) && (contains(wand->origin(this))))
					{
					//add to set of wands inside
					inside.push_back(wand);
					insideUser.push_back(user);
					//if wand was not previously inside generate enter event
					if (!previouslyInside(wand))
						{
						ygString args("wand=");
						args += wand->name();
						args += " user=";
						args += user->name();
						//a wand and associated user have entered the space
						eventOccurred("enter",args);
						}
					//generate any flags associated with the wand
					if (wand->numFlags() > 0)
						{
						ygString event;
						ygString args("wand=");
						args += wand->name();
						args += " user=";
						args += user->name();
						for (f=0; f < wand->numFlags(); f++)
							{
							wand->getFlag(f,event);
							//any wand events are generated while in the space
							eventOccurred(event,args);
							}
						}
					}
				}
			}
		}
	p_->prevInside.swap(inside);
	p_->prevInsideUser.swap(insideUser);
	//for each wand inside
	for (i=0; i < inside.size(); i++)
		{
		//if not previously inside then generate exit event
		if (!previouslyInside(inside[i]))
			{
			ygString args("wand=");
			args += inside[i]->name();
			if (insideUser[i])
				{
				args += " user=";
				args += insideUser[i]->name();
				}
			//a wand and associated user have exited the space
			eventOccurred("exit",args);
			}
		}
	ygSpace::app();
	}


bool wandTrigger::previouslyInside(const ygWand *w) const
	{
	int i;
	for (i=0; i < p_->prevInside.size(); i++)
		if (w == p_->prevInside[i])
			return true;
	return false;
	}
