// Description: a space that generates position events in the presence of a user and wand
//
//<b>notes:</b>
//<ul>
//<li> derived nodes inherit all messages from their base classes
//<li> see reset method for default settings
//<li> for volume messages refer to the <a href="ygSpace.html">ygSpace</a> node
//<li> this node requires the user have a <a href="ygCAVEHead.html">ygCAVEHead</a> node
//<li> this node requires the user have a <a href="ygCAVEWand.html">ygCAVEWand</a> node
//<li> all wand events are also generated by this node (ex. button1)
//</ul>
//
// Category: Trigger
// Author: Dave Pape
// Revision: 11/01/01
//
#include <ygUser.h>
#include <ygWand.h>
#include <ygUtil.h>
#include <ygWorld.h>
#include "wandPosition.h"

extern "C" ygNode* construct_wandPosition(const char* name,bool master) { return new wandPosition(name,master); }

wandPosition::wandPosition(const char* name,bool master) : ygSpace(name,master)
	{
	setClassName("wandPosition");
	debugFlag("inside", &debugInside);
	}

wandPosition::~wandPosition(void)
	{
	}


void wandPosition::reset(void)
	{
	//clear set of users previously inside
	prevInside.clear();
	prevInsideUser.clear();
	lastFrame = ygWorld::FrameNumber;
	local = true;
	ygSpace::reset();
	}


void wandPosition::app(void)
	{
	vector<ygWand*> inside;
	vector<ygUser*> insideUser;
	int i,j,f;
	if (lastFrame < (ygWorld::FrameNumber-1))
		{
		prevInside.clear();
		prevInsideUser.clear();
		}
	lastFrame = ygWorld::FrameNumber;
	//for each user in the world
	for (i=0; i < ygWorld::World->numUsers(); i++)
		{
		ygUser * user = ygWorld::World->user(i);
		//for each associated wand
		for (j=0; j < user->numWands(); j++)
			{
			if (user->wand(j) && user->wand(j)->isOfClass("ygWand"))
				{
				ygWand * wand = (ygWand*) (user->wand(j));
				if (wand)
					{
					//if wand is within the space then
					pfVec3 position = wand->origin(this);
					if (contains(position))
						{
						if (debugInside)
							cout << name() << ": " << user->name() << " with wand " << wand->name() << " is inside\n";
						//add to set of wands inside
						inside.push_back(wand);
						insideUser.push_back(user);
						ygString args("wand=");
						args += wand->name();
						args += " user=";
						args += user->name();
						if (!local)
							position = wand->origin();
						char value[32];
						args += " xpos=";
						sprintf(value,"%f",position[0]);
						args += value;
						args += " ypos=";
						sprintf(value,"%f",position[1]);
						args += value;
						args += " zpos=";
						sprintf(value,"%f",position[2]);
						args += value;
						//a wand is inside the space
						eventOccurred("inside",args);
						//if wand was not previously inside generate enter event
						if (!previouslyInside(wand))
							{
							//a wand and associated user have entered the space
							eventOccurred("enter",args);
							}
						//generate any flags associated with the wand
						if (wand->numFlags() > 0)
							{
							for (f=0; f < wand->numFlags(); f++)
								{
								ygString event;
								wand->getFlag(f,event);
								//any wand events are generated while in the space
								eventOccurred(event,args);
								}
							}
						}
					}
				}
			}
		}
	prevInside.swap(inside);
	prevInsideUser.swap(insideUser);
	//for each wand inside
	for (i=0; i < inside.size(); i++)
		{
		//if not previously inside then generate exit event
		if (!previouslyInside(inside[i]))
			{
			ygString args("wand=");
			args += inside[i]->name();
			if (insideUser[i])
				{
				args += " user=";
				args += insideUser[i]->name();
				}
			//a wand and associated user have exited the space
			eventOccurred("exit",args);
			}
		}
	ygSpace::app();
	}


bool wandPosition::previouslyInside(const ygWand *w) const
	{
	int i;
	for (i=0; i < prevInside.size(); i++)
		if (w == prevInside[i])
			return true;
	return false;
	}
