#ifndef _viewTexture_h_
#define _viewTexture_h_

#include <Performer/pf/pfChannel.h>
#include <Performer/pr/pfTexture.h>
#include <vector>
#include "ygNode.h"

using namespace std;

typedef struct _channelData channelData_t;

class viewTexture : public ygNode
	{
	public:
	 viewTexture(const char* name,bool master=true);
	 ~viewTexture(void);
	 virtual void reset(void);
	 virtual void message(const ygMessage&);
	 virtual void app(void);
	 virtual void acceptNetKey(const ygString&);
	 static void viewCullChannel(pfChannel*,void*);
	 static void viewDrawChannel(pfChannel*,void*);
	private:
	 vector<pfChannel*> viewChannels;
	 static int caveChannelNum;
	 channelData_t* channelData;
	 pfGeoState* gstate;
	 pfVec2 fov;
	 ygString filename;
	 ygString savename;
	 ygString scenename;
	 ygNode* scenenode;
	 pfScene* scene;
	 int xSize;
	 int ySize;
	 void setScene(const ygString&);
	 void setFOV(float,float);
	 void setTexture(const ygString&);
	 void saveTexture(const ygString&);
	 void setChildrenTextures(pfNode*);
	 void setGeosetTexture(pfGeoSet*);
	 void updateChannels(void);
	};


#endif
