#ifndef _value_h_
#define _value_h_

#include "ygNode.h"

class value : public ygNode
	{
	public:
	 value(const char*,bool master=true);
	 ~value(void);
	 virtual void reset(void);
	 virtual void message(const ygMessage&);
	 virtual void app(void);
	 virtual void appTraverse(void);
	 float getValue(int element=0) const;
	 float getLastValue(int element=0) const;
	 int getSize() const;
	 void setValue(const float& ivalue,int element=0);
	protected:
	 bool isChanged(void);
	 void clampValues(void);
	 ygString getArguments(ygString args="");
	 virtual void setValueSize(int);
	 void setSize(float*&,int,int,float=0.0);
	 float* values;
	 float* lastValues;
	 int size;
	 float* deltas;
	 int numDeltas;
	 float* minimums;
	 float* maximums;
	 int numMins;
	 int numMaxs;
	 bool integer;
	 value* reference;
	};

#endif
