#ifndef _valuator_h_
#define _valuator_h_

#include <Performer/pf/pfDCS.h>
#include "interpolate.h"

class valuator : public interpolate
	{
	public:
	 valuator(const char* name,bool master=true);
	 ~valuator(void);
	 virtual void reset(void);
	 virtual void message(const ygMessage&);
	 virtual void app(void);
	 void getMatrix(pfMatrix&) const;
	 void setMatrix(pfMatrix&);
	 void setPosition(float x,float y,float z);
	 void setOrientation(float x,float y,float z);
	 inline	void setPosition(pfVec3 v) { setPosition(v[0],v[1],v[2]); }
	 inline	void setOrientation(pfVec3 v) { setOrientation(v[0],v[1],v[2]); }
	protected:
	 virtual void acceptNetKey(const ygString&);
	 void calculateTransform(void);
	 void updateTransform(void);
	private:
	 bool grab;
	 ygString nodeName;
	 ygNode* node;
     pfMatrix deltaMatrix;
	 pfDCS* dcs;
	 pfCoord netCoord;
	 float updateInterval;
	 float lastUpdate;
	};


#endif
