// Description: a space that generates events in the presence of a user head
//
//<b>notes:</b>
//<ul>
//<li> derived nodes inherit all messages from their base classes
//<li> see reset method for default settings
//<li> for volume messages refer to the <a href="ygSpace.html">ygSpace</a> node
//<li> this node requires the user have a <a href="ygCAVEHead.html">ygCAVEHead</a> node
//</ul>
//
// Category: Trigger
// Author: Dave Pape
// Revision: 11/01/01
//
#include <ygUser.h>
#include <ygWorld.h>
#include <ygUtil.h>
#include <set>
#include "userTrigger.h"

using namespace std;


extern "C" ygNode* construct_userTrigger(const char* name,bool master) { return new userTrigger(name,master); }


struct _userTriggerPrivateData
	{
	set<ygUser*> prevInside;
	bool debugInside;
	int lastFrame;
	};


userTrigger::userTrigger(const char* name,bool master) : ygSpace(name,master)
	{
	setClassName("userTrigger");
	p_ = new struct _userTriggerPrivateData;
	p_->lastFrame = ygWorld::FrameNumber;
	debugFlag("inside", &p_->debugInside);
	}


userTrigger::~userTrigger(void)
	{
	delete p_;
	}


void userTrigger::reset(void)
	{
	//clear set of users previously inside
	p_->prevInside.clear();
	p_->lastFrame = ygWorld::FrameNumber;
	ygSpace::reset();
	}


void userTrigger::app(void)
	{
	set<ygUser*> inside;
	int i;
	if (p_->lastFrame < (ygWorld::FrameNumber-1))
		p_->prevInside.clear();
	p_->lastFrame = ygWorld::FrameNumber;
	//for each user in the world
	for (i=0; i < ygWorld::World->numUsers(); i++)
		{
		ygUser * user = ygWorld::World->user(i);
		//if head is within the space
		if ((user->head()) &&
		    (contains(user->head()->origin(this))))
			{
			if (p_->debugInside)
				cout << name() << ": " << user->name() << " is inside\n";
			//add to set of users inside
			inside.insert(inside.begin(),user);
			//if inside but not previously then generate enter event
			if (p_->prevInside.find(user) == p_->prevInside.end())
				{
				ygString args("user=");
				args += user->name();
				//a user has entered the space
				eventOccurred("enter",args);
				}
			}
		}
	set<ygUser*>::const_iterator iter;
	//for each user previously inside
	for (iter = p_->prevInside.begin(); iter != p_->prevInside.end();++iter)
		{
		//if not currently inside then generate exit event
		if (inside.find(*iter) == inside.end())
			{
			ygString args("user=");
			args += (*iter)->name();
			//a user has exited the space
			eventOccurred("exit",args);
			}
		}
	//if not previously empty and now empty generate empty event
	if ((p_->prevInside.size() > 0) && (inside.size() == 0))
		{
		//all users have exited the space
		eventOccurred("empty");
		}
	//if previously empty and now not empty generate firstenter event
	if ((p_->prevInside.size() == 0) && (inside.size() > 0))
		{
		ygString args("user=");
		args += (*(inside.begin()))->name();
		//a user has entered a previously empty space
		eventOccurred("firstenter",args);
		}
	p_->prevInside = inside;
	ygSpace::app();
	}
