// Description: a transform that rotates an arc angle about an axis
//
//<b>notes:</b>
//<ul>
//<li> derived nodes inherit all messages from their base classes
//<li> see reset method for default settings
//<li> this node can also be implemented with a <a href="timer.html">timer</a> node
//</ul>
//
// Category: Deprecated
// Author: Brenda Lopez
// Revision: 11/01/01
//
#include "ygWorld.h"
#include "turner.h"

extern "C" ygNode* construct_turner(const char* n) { return new turner(n); }

struct _turnerPrivateData
	{
	bool myDebug;
	};

enum _states { TURNER_START, TURNER_GO_FORWARD, TURNER_GO_BACK, TURNER_END };

enum _swingStates { ON, OFF };


turner::turner(const char* n) : ygSimpleTransform(n)
	{
	setClassName("turner");
	p_ = new struct _turnerPrivateData;
	axis_.set(0, 0, 1);
	minAngle_ = 0;
	maxAngle_ = 180;
	duration_ = 1;
	state_ = TURNER_START;
	swingState_ = OFF;
	}

turner::~turner(void)
	{
	delete p_;
	}


void turner::reset(void)
	{
	//set axis to (0,0,1)
	axis_.set(0, 0, 1);
	//set min angle to 0.0
	minAngle_ = 0;
	//set max angle to 180.0
	maxAngle_ = 180;
	//set duration to 1.0
	duration_ = 1;
	//set state to start
	state_ = TURNER_START;
	//set swing mode to off
	swingState_ = OFF;
	ygSimpleTransform::reset();
	}


void turner::message(const ygMessage& msg)
	{
	//set axis to rotate about
	if (msg == "axis")
		{
		msg.getVec3Args(axis_);
		initialRotation();
		}
	//set minimum rotation angle
	else if (msg == "minangle")
		{
		minAngle_ = msg.floatArg(0);
		initialRotation();
		}
	//set maximum rotation angle
	else if (msg == "maxangle")
		maxAngle_ = msg.floatArg(0);
	//set rotation duration
	else if (msg == "duration")
		duration_ = msg.floatArg(0);
	//start turn from minimum angle
	else if (msg == "turn")
		turn();
	//turn back from maximum angle
	else if (msg == "turnback")
		turnBack();
	//set swing mode to on
	else if (msg == "swing")
		swing();
	else
		ygSimpleTransform::message(msg);
	}


void turner::initialRotation(void)
	{
	pfMatrix rotmat;
	rotmat.makeRot( minAngle_, axis_[0], axis_[1], axis_[2] );
	setMatrix(rotmat);
	}

void turner::swing(void)
{
    swingState_ = ON;
    state_ = TURNER_GO_FORWARD;
    startTime_ = ygWorld::FrameTime;
}


void turner::turn(void)
{
    if (state_ == TURNER_START)
    {
        state_ = TURNER_GO_FORWARD;
        startTime_ = ygWorld::FrameTime;
    }
    else if (state_ == TURNER_GO_BACK)
    {
        state_ = TURNER_GO_FORWARD;
        startTime_ = ygWorld::FrameTime -
		(duration_ - (ygWorld::FrameTime -  startTime_));
    }
}


void turner::turnBack(void)
{
    if (state_ == TURNER_END)
    {
        state_ = TURNER_GO_BACK;
        startTime_ = ygWorld::FrameTime;
    }
    else if (state_ == TURNER_GO_FORWARD)
    {
        state_ = TURNER_GO_BACK;
        startTime_ = ygWorld::FrameTime - (duration_ - (ygWorld::FrameTime -  startTime_));
    }
}


void turner::app(void)
	{
	if (state_ == TURNER_GO_FORWARD)
	{
	    float    t = ygWorld::FrameTime -startTime_, angle;
	    pfMatrix rotmat;
    
	    if (t > duration_)
	    {
		t = duration_;
		if (swingState_ == ON)
		{
		    startTime_ = ygWorld::FrameTime;
		    state_ = TURNER_GO_BACK;
		}
		else
		    state_ = TURNER_END;
	    }
    
	    angle = minAngle_ + (maxAngle_ - minAngle_) * t / duration_;
	    rotmat.makeRot(angle, axis_[0], axis_[1], axis_[2]);
	    setMatrix(rotmat);
	}
	else if (state_ == TURNER_GO_BACK)
	{
	    float    t = ygWorld::FrameTime -startTime_, angle;
	    pfMatrix rotmat;
    
	    if (t > duration_)
	    {
		t = duration_;
		if (swingState_ == ON)
		{
		    startTime_ = ygWorld::FrameTime;
		    state_ = TURNER_GO_FORWARD;
		}
		else
		    state_ = TURNER_START;
	    }
    
	    angle = maxAngle_ + (minAngle_ - maxAngle_) * t / duration_;
	    rotmat.makeRot(angle, axis_[0], axis_[1], axis_[2]);
	    setMatrix(rotmat);
	}
	ygSimpleTransform::app();
	}
