// Description: a transform that swings between two positions in a duration
//
//<b>notes:</b>
//<ul>
//<li> derived nodes inherit all messages from their base classes
//<li> see reset method for default settings
//<li> this node does not affect orientation
//<li> this node can also be implemented with a <a href="timer.html">timer</a> node
//</ul>
//
// Category: Deprecated
// Author: Dave Pape
// Revision: 11/01/01
//
#include <ygWorld.h>
#include "toAndFrom.h"

using namespace std;

extern "C" ygNode* construct_toAndFrom(const char* name,bool master) { return new toAndFrom(name,master); }

enum _objectState
{
    GO_HERE,
    GO_THERE,
    IDLE, 
    TOGGLE, 
};


toAndFrom::toAndFrom(const char* name,bool master) : ygSimpleTransform(name,master)
	{
	setClassName("toAndFrom");	
	start_pos_.set (0, 0, 0);
	end_pos_.set (0, 0, 0);
	state_ = IDLE;
	previousState_ = GO_HERE;
	loop_ = 0;
	startTime_ = 0;
	duration_ = 0;
	}

toAndFrom::~toAndFrom(void)
	{
	
	}


void toAndFrom::reset(void)
	{
	//set state to idle
	state_ = IDLE;
	//set loop to zero
	loop_ = 0;
	//set start time to zero
	startTime_ = 0;
	ygSimpleTransform::reset();
	}


void toAndFrom::message(const ygMessage& msg)
	{
	//set start position
	if (msg == "startpos")
	{
	    msg.getVec3Args(start_pos_);
	    setStartPos();
	}
	//set end position
	else if (msg == "endpos")
	    msg.getVec3Args(end_pos_);
	//set move duration
	else if (msg == "duration")
	    duration_ = msg.floatArg(0);
	//set state to go there
	else if (msg == "there")
	    setState(GO_THERE);
	//set state to go here
	else if (msg == "here")
	    setState(GO_HERE);
	//set state to toggle
	else if (msg == "toggle")
	    setState(TOGGLE);
	//set mode to loop
	else if (msg == "loop")
	    setLoop();
	//set mode not to loop
	else if (msg == "stoploop")
	    stopLoop();	    
	else
		ygSimpleTransform::message(msg);
	}

void toAndFrom::setStartPos(void)
{
    setPosition (start_pos_[0], start_pos_[1], start_pos_[2]);
}


void toAndFrom::setState(int s)
{  
    state_ = s;
    if (state_ == GO_THERE)
	startTime_ = ygWorld::FrameTime;
    if (state_ == GO_HERE)
	startTime_ = ygWorld::FrameTime;
    if (state_ == TOGGLE)
    {
	startTime_ = ygWorld::FrameTime;
	if(previousState_ == GO_THERE)
	{
	    setPreviousState(GO_HERE);
	    setState (GO_HERE);
	}
	
	else
	{
	    setPreviousState(GO_THERE);
	    setState (GO_THERE);
	}
    }
}

void toAndFrom::setPreviousState(int s)
{  
    previousState_ = s;
}

void toAndFrom::setLoop(void)
{
    loop_ = 1;
}


void toAndFrom::stopLoop(void)
{
    loop_ = 0;
}


void toAndFrom::app(void)
	{
	if (state_ == GO_THERE)
	    goThere();

	else if (state_ == GO_HERE)
	    goHere();

	ygSimpleTransform::app();
	}


void toAndFrom::goThere(void)
	{
	    pfVec3  cur_pos;
	    if (((ygWorld::FrameTime - startTime_) < duration_) && (fabs(duration_) > 0.0000001f))
	    {
		float   t = (ygWorld::FrameTime - startTime_) / duration_;
	
		cur_pos = (1.0 - t) * start_pos_ + t * end_pos_;
		setPosition (cur_pos[0], cur_pos[1], cur_pos[2]);
	    }
	    else
	    {
		setPosition (end_pos_[0], end_pos_[1], end_pos_[2]);
		
		if(loop_)
		    setState(GO_HERE);
		else
		    setState(IDLE);
	    }
	}

void toAndFrom::goHere(void)
	{
	    pfVec3  cur_pos;
	    
	    if (((ygWorld::FrameTime - startTime_) < duration_) && (fabs(duration_) > 0.0000001f))
	    {
		float   t = (ygWorld::FrameTime - startTime_) / duration_;
	    
		cur_pos = (1.0 - t) * end_pos_ + t * start_pos_;
		setPosition (cur_pos[0], cur_pos[1], cur_pos[2]);
	    }
	    else
	    {
		setPosition (start_pos_[0], start_pos_[1], start_pos_[2]);
		
		if(loop_)
		    setState(GO_THERE);
		else
		    setState(IDLE);
	    }    
	}
	
