// Description: a node that creates a 3D string of text
//
//<b>notes:</b>
//<ul>
//<li> derived nodes inherit all messages from their base classes
//<li> see reset method for default settings
//<li> valid fonts are located in /usr/share/Performer/data with the extention *.mf
//</ul>
//
// Category: Geometry
// Author: Alex Hill
// Revision: 04/02/03
//
#include <Performer/pfdu.h>
#include <Performer/pr/pfString.h>
#include <Performer/pf/pfText.h>
#include <Performer/pf/pfGroup.h>
#include <ygNetKeys.h>
#include "text.h"

using namespace std;

extern "C" ygNode* construct_text(const char* name,bool master) { return new text(name,master); }


text::text(const char* name,bool master) : ygNode(name,master)
	{
	setClassName("text",true);
	pfFont *font = pfdLoadFont_type1("/usr/share/Performer/data/Times-Elfin",PFDFONT_EXTRUDED);
 	string = new pfString;
 	string->setFont(font);
  	pfText* text = new pfText;
	text->addString(string);
	pfnode()->addChild(text);
	addNetKey("string",&netString,YG_NET_STRING);
	addNetKey("color",&netColor,YG_NET_VEC4);
	addNetKey("font",&netFont,YG_NET_STRING);
	}

text::~text(void)
	{
	}


void text::reset(void)
	{
	string->setString("");
	netKeyChanged("string");
	//set default font to "Times-Elfin"
	pfFont *font = pfdLoadFont_type1("/usr/share/Performer/data/Times-Elfin",PFDFONT_EXTRUDED);
	//set default style to extruded
 	string->setFont(font);
	netFont = "Times-Elfin";
	netKeyChanged("font");
	//set color to (0,0,0,1)
	netColor.set(0,0,0,1);
	netKeyChanged("color");
	ygNode::reset();
	}


void text::message(const ygMessage& msg)
	{
	//set text string to be generated
	if (msg == "string")
		{
		if (msg.args.size() == 1)
			{
			netString = msg.args[0];
			string->setString(netString.c_str());
			//distribute the string to clients
			netKeyChanged("string");
			}
		else
			msg.error(name(),"(wrong number of arguments)");
		}
	//set the color of the text
	else if (msg == "color")
		{
		pfVec4 v4;
		pfVec3 v3;
		if (msg.getVec4Args(v4))
			{
			string->setColor(v4[0],v4[1],v4[2],v4[3]);
			netColor = v4;
			//distribute the color to clients
 			netKeyChanged("color");
			}
		else if (msg.getVec3Args(v3))
			{
			string->setColor(v3[0],v3[1],v3[2],1.0);
			netColor.set(v3[0],v3[1],v3[2],1.0);
			//distribute the color to clients
			netKeyChanged("color");
			}
		else
			msg.error(name(),"(wrong number of arguments)");
		}
	//set the font and optional style
	else if (msg == "font")
		{
		if (msg.args.size() > 0)
			{
			ygString fontName("/usr/share/Performer/data/");
			netFont = msg.args[0];
			fontName += netFont;
			int style;	
			if (msg.args.size() > 1)
				{
				//if second argument is "textured"
				if (msg.args[1] == "extruded")
					{
					//set style to PFDFONT_TEXTURED
					style = PFDFONT_TEXTURED;
					}
				//if second argument is "outlined"
				else if (msg.args[1] == "outlined")
					{
					//set style to PFDFONT_OUTLINED
					style = PFDFONT_OUTLINED;
					}
				//if second argument is "filled"
				else if (msg.args[1] == "filled")
					{
					//set style to PFDFONT_FILLED
					style = PFDFONT_FILLED;
					}
				else
					style = PFDFONT_EXTRUDED;
				}
			pfFont *font = pfdLoadFont_type1(fontName.c_str(),style);
			string->setFont(font);
			char styleStr[32];
			sprintf(styleStr," %d",style);
			netFont += styleStr;
			netKeyChanged("font");
			}
		else
			msg.error(name(),"(wrong number of arguments)");
		}
	else
		ygNode::message(msg);
	}

void text::acceptNetKey(const ygString& key)
	{
	if (key == "string")
		string->setString(netString.c_str());
	else if (key == "color")
		string->setColor(netColor[0],netColor[1],netColor[2],netColor[3]);
	else if (key == "font")
		{
		ygString *fontStr,*styleStr;
		int index=0;
		int style = PFDFONT_EXTRUDED;
		ygString fontName("/usr/share/Performer/data/");
		fontStr = netFont.nextToken(" ",&index);
		styleStr = netFont.nextToken(" ",&index);
		if (styleStr)
			style = atoi(styleStr->c_str());
		fontName += *fontStr;
		pfFont *font = pfdLoadFont_type1(fontName.c_str(),style);
		string->setFont(font);
		}
	else
		ygNode::acceptNetKey(key);
	}
