#ifndef _surface_h_
#define _surface_h_

#include <Performer/pf/pfGroup.h>
#include <Performer/pf/pfGeode.h>
#include <Performer/pr/pfGeoSet.h>
#include <Performer/pr/pfMaterial.h> 
#include <Performer/pr/pfTexture.h>
#include <Performer/pr.h>
#include "geometry.h"

class surface : public geometry
	{
	public:
	 surface(const char* name,bool master=true);
	 ~surface(void);
	 virtual void reset(void);
	 virtual void message(const ygMessage&);
	 virtual void app(void);
	protected:
	 pfVec2 vertices_;
	 pfVec2 netVertices_;
	 pfVec4 color_;
	 ygString textureFile;
	 pfMaterial* mat;
	 pfVec2* texCoords;
	 pfVec3* verts;
	 pfVec3* norms;
	 pfVec4* colors;
	 pfTexture* texture;
	 pfGeode* geode;
	 pfGeoState* gstate;
	 pfGeoSet* gset;
	 ushort* ilist;
	 void acceptNetKey(const ygString&);	
	 void setColor(pfVec4);
	 void setTexture(const ygString&);
	 void createGeometry(int,int);
	};

#endif
