/*
 * Ygdrasil Version 0.1.5
 */
#ifndef _spotLight_h_
#define _spotLight_h_

#include <Performer/pr/pfLinMath.h>
#include "ygSimpleTransform.h"


class spotLight : public ygSimpleTransform
	{
	public:
	 spotLight(const char*,bool master=true);
	 virtual ~spotLight(void);
	 virtual void reset(void);
	 virtual void message(const ygMessage&);
		 void on(void);
		 void off(void);
		 void toggle(void);
		 bool isOn(void) const;
		 void setAttenuation(float c,float l,float q);
		 void setCone(float,float,float);
		 void setAmbient(float r,float g,float b);
		 void setDiffuse(float r,float g,float b);
		 void setSpecular(float r,float g,float b);
	 inline	 void setAttenuation(pfVec3 v) { setAttenuation(v[0],v[1],v[2]); }
	 inline	 void setCone(pfVec3 v) { setCone(v[0],v[1],v[2]);}
	 inline	 void setAmbient(pfVec3 v) { setAmbient(v[0],v[1],v[2]); }
	 inline	 void setDiffuse(pfVec3 v) { setDiffuse(v[0],v[1],v[2]); }
	 inline	 void setSpecular(pfVec3 v) { setSpecular(v[0],v[1],v[2]); }
	protected:
	 virtual void acceptNetKey(const ygString&);
	private:
	 struct _spotLightPrivateData *p_;
	};


extern "C" ygNode* construct_spotLight(const char*,bool);

#endif
