// Description: a transform that rotates about the Z axis over a period
//
//<b>notes:</b>
//<ul>
//<li> derived nodes inherit all messages from their base classes
//<li> see reset method for default settings
//<li> this node can also be implemented with a <a href="timer.html">timer</a> node
//</ul>
//
// Category: Deprecated
// Author: Dave Pape
// Revision: 11/01/01
//
#include "ygWorld.h"
#include "spinner.h"

extern "C" ygNode* construct_spinner(const char* name,bool master) { return new spinner(name,master); }


spinner::spinner(const char* name,bool master) : ygSimpleTransform(name,master)
	{
	setClassName("spinner");
	reset();
	}


void spinner::reset(void)
	{
	//set the period to 1 second
	period_ = 1;
	ygSimpleTransform::reset();
	}


void spinner::message(const ygMessage& msg)
	{
	//set the period for one full rotation
	if (msg == "period")
		setPeriod(msg.floatArg(0));
	else
		ygSimpleTransform::message(msg);
	}


void spinner::setPeriod(float p)
	{
	if (fabs(p) > 0.0001f)
		period_ = p;
	else
		period_ = 1;
	}


void spinner::app(void)
	{
	float angle = ygWorld::FrameTime/period_ * 360.0f;
	setOrientation(0, 0, angle);
	ygSimpleTransform::app();
	}
