#ifndef _smoke_h_
#define _smoke_h_

#include "ygNode.h"
#include <Performer/pfutil.h>

typedef struct _smokeData smokeData_t;

class smoke : public ygNode
	{
	public:
	 smoke(const char* name,bool master=true);
	 ~smoke(void);
	 virtual void reset(void);
	 virtual void message(const ygMessage&);
	 virtual void app(void);
	 static int smokePreDraw(pfTraverser*,void*);
	 static int smokePostDraw(pfTraverser*,void*);
	protected:
	 virtual void acceptNetKey(const ygString&);
	private:
	 void createSmoke(void);
	 pfVec2 velocity;
	 pfVec3 density;
	 pfCoord color;
	 pfuSmoke* smoke_;
	 int type;
	 bool active;	 
	 smokeData_t* data_;
	};

#endif
