// Description: a transform that moves between two positions in a duration
//
//<b>notes:</b>
//<ul>
//<li> derived nodes inherit all messages from their base classes
//<li> all parent node messages are inherited
//<li> see reset method for default settings
//<li> this node does not affect orientation
//<li> this node can also be implemented with a <a href="timer.html">timer</a> node
//</ul>
//
// Category: Deprecated
// Author: Dave Pape
// Revision: 11/01/01
//
#include "ygWorld.h"
#include "simpleMover.h"

using namespace std;

extern "C" ygNode* construct_simpleMover(const char* name,bool master) { return new simpleMover(name,master); }

struct _simpleMoverPrivateData
	{
	pfVec3 start, end;
	float moveTime;
	bool active, forward;
	float startTime;
	};


simpleMover::simpleMover(const char* name,bool master) : ygSimpleTransform(name,master)
	{
	setClassName("simpleMover");
	p_ = new struct _simpleMoverPrivateData;
	p_->start.set(0,0,0);
	p_->end.set(0,0,0);
	p_->moveTime = 1;
	p_->active = false;
	p_->forward = true;
	}

simpleMover::~simpleMover(void)
	{
	delete p_;
	}


void simpleMover::reset(void)
	{
	//set start position to (0,0,0)
	p_->start.set(0,0,0);
	//set end position to (0,0,0)
	p_->end.set(0,0,0);
	//set move time to 1 second
	p_->moveTime = 1;
	//set active to false;
	p_->active = false;
	//set forward to false
	p_->forward = false;
	ygSimpleTransform::reset();
	}


void simpleMover::message(const ygMessage& msg)
	{
	//set the start position
	if (msg == "start")
		msg.getVec3Args(p_->start);
	//set the end position
	else if (msg == "end")
		msg.getVec3Args(p_->end);
	//set the move time
	else if (msg == "time")
		p_->moveTime = msg.floatArg(0);
	//start the motion
	else if (msg == "go")
		go();
	else
		ygSimpleTransform::message(msg);
	}


void simpleMover::go(void)
	{
	//if not active then
	if (!p_->active)
		{
		//set active true
		p_->active = true;
		//set forward to not forward
		p_->forward = !p_->forward;
		//set start time to frame time
		p_->startTime = ygWorld::FrameTime;
		}
	}


void simpleMover::app(void)
	{
	//if active then
	if (p_->active)
		{
		//calculate time since start time
		float t = ygWorld::FrameTime - p_->startTime;
		//if time is greater than move time
		if (t >= p_->moveTime)
			{
			//set time to move time
			t = p_->moveTime;
			//set active to false
			p_->active = false;
			}
		//calculate percentage into move
		float a = t / p_->moveTime;
		pfVec3 pos;
		//if forward then 
		if (p_->forward)
			{
			//interpolate from the start
			pos = (1.0f-a) * p_->start + a * p_->end;
			}
		else
			{
			//else, interpolate from the end
			pos = (1.0f-a) * p_->end + a * p_->start;
			}
		//set transform position
		setPosition(pos);
		}
	ygSimpleTransform::app();
	}
