// Description: an array that is created and updated on each client
//
//<b>notes:</b>
//<ul>
//<li> derived nodes inherit all messages from their base classes
//<li> see reset method for default settings
//</ul>
//
// Category: Math
// Author: Alex Hill
// Revision: 01/21/03
//
#include <ygNetKeys.h>
#include "remoteValue.h"

extern "C" ygNode* construct_remoteValue(const char* name,bool master) { return new remoteValue(name,master); }

remoteValue::remoteValue(const char* name,bool master) : value(name,master)
	{
	setClassName("remoteValue",true);
	//distribute the size of the array
	addNetKey("size",&netSize,YG_NET_INT);
	numKeys = 3;
	netSize = 1;
	netValues = (pfVec3*)malloc(sizeof(pfVec3)*numKeys);
	for (int i=0; i<numKeys; i++)
		{
		ygString keyName("value");
		char str[4];
		sprintf(str,"%d",i);
		keyName += str;
		netKeys.push_back(keyName);
		//array values are distributed in groups of three
		addNetKey(netKeys[i],&netValues[i],YG_NET_VEC3);
		for (int j=0; j<3; j++)
			netValues[i].vec[j] =0.0;
		}
	}

remoteValue::~remoteValue(void)
	{
	}

void remoteValue::reset(void)
	{
	value::reset();
	}
	
void remoteValue::app(void)
	{
	value::app();
	if (isNetMaster())
		{
		if (size != netSize)
			{
			netSize = size;
			netKeyChanged("size");
			}
		for (int i=0; i<numKeys; i++)
			{
			int index = 3*i;
			if (netSize > index)
				{
				int maxSize = index+3;
				if (netSize < maxSize)
					maxSize = netSize-index; 
				bool changed = false;
				for (int j=0; j<maxSize; j++)
					{
					if (netValues[i].vec[j] != values[index+j])
						changed = true;
					netValues[i].vec[j] = values[index+j];
					}
				if (changed)
					netKeyChanged(netKeys[i]);
				}
			}
		}
	}

void remoteValue::acceptNetKey(const ygString& key)
	{
	if (key == "size")
		setValueSize(netSize);
	else
		{
		bool found = false;
		for (int i=0; i<numKeys; i++)
			{
			if (key == netKeys[i])
				{
				found = true;
				int index = 3*i;
				if (netSize > index)
					{
					int maxSize = index+3;
					if (netSize < maxSize)
						maxSize = netSize-index; 
					for (int j=0; j<maxSize; j++)
						 values[index+j] = netValues[i].vec[j];
					}
				}
			}
		if (!found)
			ygNode::acceptNetKey(key);
		}
	}
