// Description: creates another instance of Performer geometry
//
//<b>notes:</b>
//<ul>
//<li> derived nodes inherit all messages from their base classes
//<li> see reset method for default settings
//<li> all geometry generated below the given node will drawn
//<li> this node can be used to duplicate complicated geometry without duplicating the nodes that generate it
//</ul>
//
// Category: Geometry
// Author: Alex Hill
// Revision: 11/01/01
//
#include <Performer/pf/pfGroup.h>
#include <ygNetKeys.h>
#include <ygNodeDB.h>
#include "reference.h"

extern "C" ygNode* construct_reference(const char* name,bool master) { return new reference(name,master); }


reference::reference(const char* name,bool master) : ygNode(name,master)
	{
	setClassName("reference",true);
	//distribute the nodeName string
    addNetKey("node",&nodeName,YG_NET_STRING);
	node = NULL;
	}


void reference::reset(void)
	{
	//remove any previously referenced node
	if (node)
		pfnode()->removeChild(node->pfnode());
	node = NULL;
	//clear nodeName string
	nodeName.clear();
	netKeyChanged("node");
	ygNode::reset();
	}


void reference::message(const ygMessage& msg)
	{
	//set the name of the node to reference
	if (msg == "node")
		{
		if (msg.args.size() == 1)
			setNode(msg.args[0]);
		else
			msg.error(name(),"(wrong number of arguments)");
		}
	else
		ygNode::message(msg);
	}


void reference::setNode(const ygString& name)
	{
	//remove any previously referenced node
	if (node)
		pfnode()->removeChild(node->pfnode());
	//set nodeName to the input string
	nodeName = name;
	//if the nodeName string is not empty then
	if (nodeName.length() > 0)
		{
		//find the associated node in the database
		node = ygNodeDB::find(nodeName);
		//if the node was found then add the associated Performer node as a child
		if (node)
			{
			pfnode()->addChild(node->pfnode());
			netKeyChanged("node");
			}
		}
	}
	
void reference::acceptNetKey(const ygString& key)
    {
    if (key == "node")
		setNode(nodeName);
    else
		ygNode::acceptNetKey(key);
    }
