#ifndef _rectSurface_h_
#define _rectSurface_h_

#include <Performer/pr/pfString.h>
#include <Performer/pf/pfGeode.h>
#include <Performer/pr/pfGeoSet.h>
#include <Performer/pr/pfGeoState.h>
#include <Performer/pr/pfMaterial.h> 
#include <Performer/pr/pfTexture.h>
#include <Performer/pf/pfGroup.h>
#include <Performer/pf/pfNode.h>
#include <Performer/pf/pfDCS.h>
#include <Performer/pf/pfSCS.h>
#include <Performer/pfdu.h>

#include "ygCAVEViewer.h"
#include "ygNode.h"
#include "ygNodeDB.h"
#include "ygWorld.h"
#include "ygNetKeys.h"
#include "ygUser.h"
#include "ygSpace.h"


class rectSurface : public ygNode 
{
	public:
		rectSurface(const char* name, bool master=false);   
  		virtual ~rectSurface();
   		virtual void message(const ygMessage&);
   		virtual void app(void);
   		virtual void reset(void);
   		void setImg(unsigned char *img, int w, int h, int ncolc);
   		void loadSubImg(unsigned char *img, int w, int h, int ncolc);
   		bool resizeImg(int w, int h, int ncolc);
   		void clear(unsigned int col);   
   		bool isCreated();
   		void setVisibility(bool vis);
   		virtual void acceptNetKey(const ygString&);
	
	protected:
		void setCoords(pfVec3& c1, pfVec3& c2, pfVec3& c3, pfVec3& c4); 
  	 	void createrectSurface();
   
	private:  
   		struct _rectSurfacePrivateData *_p;
};
 

extern "C" ygNode* construct_rectSurface(const char*,bool);
 
 
#endif



