// Description: an array that is read from a file
//
//<b>notes:</b>
//<ul>
//<li> derived nodes inherit all messages from their base classes
//<li> see reset method for default settings
//<li> see the <a href="value.html">value</a> node for more information
//</ul>
//
// Category: Math
// Author: Alex Hill
// Revision: 11/01/04
//
#include <ygUtil.h>
#include "readFile.h"

extern "C" ygNode* construct_readFile(const char* name,bool master) { return new readFile(name,master); }

readFile::readFile(const char* name,bool master) : value(name,master)
	{
	setClassName("readFile");
	fp = NULL;
	}

readFile::~readFile(void)
	{
	if (fp)
		fclose(fp);
	}

void readFile::reset(void)
	{
	filename.clear();
	if (fp)
		fclose(fp);
	fp = NULL;
	value::reset();
	}
	
void readFile::message(const ygMessage& msg)
	{
	//the filename of the data file to read from
	if (msg == "file")
		{
		if (msg.args.size() > 0)
			{
			filename = msg.args[0];
			openFile(filename);
			}
		}
	//read in one value for each array element
	else if (msg == "read")
		{
		if (fp)
			{
			for (int i=0; i<size; i++)
				fscanf(fp,"%g%",&values[i]); 
			}
		}
	else
		value::message(msg);
	}
   
 
void readFile::openFile(const ygString& file)
	{
	char *searchPath = ".";
	ygString fullPath;
	if (getenv("YG_PATH"))
		searchPath = getenv("YG_PATH");
	if (!ygFindFile(file,searchPath,fullPath))
		{
		fprintf(stderr,"ERROR: readFile: could not find file '%s'\n",file.c_str());
		return;
		}
	if (fp)
		fclose(fp);
	fp = fopen(fullPath.c_str(),"r");
	if (!fp)
		fprintf(stderr,"ERROR: readFile: could not open \"%s\"\n",fullPath.c_str());
	}
