#ifndef _rain_h_
#define _rain_h_

#include "ygNode.h"

class rain : public ygNode
	{
	public:
	 rain(const char* name,bool master=true);
	 virtual void reset(void);
	 virtual void message(const ygMessage&);
	 virtual void app(void);
	 inline float randomVal(float min, float max) {return (min + drand48()*(max - min));};
	private:
	 pfVec3* rain_;
	 pfCoord range_;
	 float ground_;
	 float speed_;
	 int count_;
	 void createGeode(void);
	 pfGeode* makeCylinder(void);
	protected:
	 virtual void acceptNetKey(const ygString&);
	};

#endif
