// Description: a node that generates the distance to the nearest user
//
//<b>notes:</b>
//<ul>
//<li> derived nodes inherit all messages from their base classes
//<li> see reset method for default settings
//<li> see the <a href="interpolate">interpolate</a> node for more information
//<li> proximity can be used in conjunction with other nodes to add dynamics to the scene
//</ul>
//
// Category: Math
// Author: Alex Hill
// Revision: 11/01/01
//
#include <Performer/pf/pfGroup.h>
#include <ygWorld.h>
#include <ygUser.h>
#include "proximity.h"

extern "C" ygNode* construct_proximity(const char* name,bool master) { return new proximity(name,master); }

proximity::proximity(const char* name,bool master) : interpolate(name,master)
	{
	setClassName("proximity");
	setPfNode(new pfGroup);
	}

proximity::~proximity(void)
	{
	}

void proximity::app(void)
	{
	float distance = 0.0;
	//for each user in the world
	for (int i=0; i < ygWorld::World->numUsers(); i++)
		{
		ygUser * user = ygWorld::World->user(i);
		//if user has a cave head
		if (user->head())
			{
			//calculate user distance
			pfVec3 userPos;
			userPos = user->head()->origin(this);
			float userDistance;
			userDistance = userPos.length();
			if (i == 0)
				{
				distance = userDistance;
				}
			else
				{
				if (userDistance < distance)
					distance = userDistance;
				}
			}
		}
	//calculate interpolated array values
	for (int i=0;i<size;i++)
		values[i] = startValues[i] + distance*(endValues[i]-startValues[i]);
	interpolate::app();
	}
