#ifndef _positioner_h_
#define _positioner_h_

#include <vector.h>
#include <map.h>
#include "valuator.h"

typedef struct pointData_ pointData;

typedef vector<pointData*> pointList;
	
class positioner : public valuator
	{
	public:
	 positioner(const char* name,bool master=true);
	 ~positioner(void);
	 virtual void reset(void);
	 virtual void message(const ygMessage&);
	 virtual void app(void);
	private:
	 static struct _positionerPrivateData* p_;
	 static pointList* listReference(const ygString&);
	 static pointList* loadPointList(const ygString& file);
	 void calcAvgDistance(void);
	 float averageDist;
	 float scaleFactor;
	 pointData* lastPoint;
	 pointList* points;
	};


#endif
