#ifndef _poserAnimator_h_
#define _poserAnimator_h_

#include <vector>
#include <ygNode.h>

using namespace std;

typedef vector<ygString> stringArray;

class poserAnimator : public ygNode
	{
	public:
	 poserAnimator(const char* name,bool master=true);
	 ~poserAnimator(void);
	 virtual void reset(void);
	 virtual void message(const ygMessage&);
	 virtual void acceptNetKey(const ygString&);
	private:
	 void setFrame(pfGroup*, int);
	 void handlePoserChannel(stringArray*,pfGroup*);
	 void setTransformation(pfGroup*,int,float*);
	 void handlePoserHierarchy(pfGroup*,FILE*);
	 void handlePoserData(pfGroup*,stringArray*,int*,int);
	 void loadPoserFile(const ygString&);	
	 void loadJointModel(pfGroup*,const ygString&);
	 void loadMapFile(const ygString&);
	 void parseMapFile(pfGroup*,FILE*);
	 ygString bvhFile;
	 ygString mapFile;
	 int frame;
	 int numFrames;
	};


#endif
