#ifndef _pointLight_h_
#define _pointLight_h_

#include <Performer/pr/pfLinMath.h>
#include "ygNode.h"


class pointLight : public ygNode
	{
	public:
	 pointLight(const char*,bool master=true);
	 virtual ~pointLight(void);
	 virtual void reset(void);
	 virtual void message(const ygMessage&);
	 virtual void app(void);
		 void on(void);
		 void off(void);
		 void toggle(void);
		 bool isOn(void) const;
		 void setPosition(float x,float y,float z,float w=0);
		 void setAmbient(float r,float g,float b);
		 void setDiffuse(float r,float g,float b);
		 void setSpecular(float r,float g,float b);
		 void setAttenuation (float con, float lin, float exp);
	 inline	 void setPosition(pfVec3 v) { setPosition(v[0],v[1],v[2],1); }
	 inline	 void setPosition(pfVec4 v) { setPosition(v[0],v[1],v[2],v[3]);}
	 inline	 void setAmbient(pfVec3 v) { setAmbient(v[0],v[1],v[2]); }
	 inline	 void setDiffuse(pfVec3 v) { setDiffuse(v[0],v[1],v[2]); }
	 inline	 void setSpecular(pfVec3 v) { setSpecular(v[0],v[1],v[2]); }
	 inline  void setAttenuation(pfVec3 v) { setAttenuation(v[0],v[1],v[2]);}
	protected:
	 virtual void acceptNetKey(const ygString&);
	private:
	 struct _pointLightPrivateData *p_;
	};


extern "C" ygNode* construct_pointLight(const char*,bool);

#endif
