// Description: a transform that uses simple physics for dynamic motion
//
//<b>notes:</b>
//<ul>
//<li> derived nodes inherit all messages from their base classes
//<li> see reset method for default settings
//</ul>
//
// Category: Transformation
// Author: Alex Hill
// Revision: 11/01/01
//
#include <ygNodeDB.h>
#include <ygWorld.h>
#include "physics.h"

extern "C" ygNode* construct_physics(const char* name,bool master) { return new physics(name,master); }

physics::physics(const char* name,bool master) : ygTransform(name,master)
    {
    setClassName("physics");
    vel_.set(0,0,0);
    accel_.set(0,0,0);
    }

physics::~physics(void)
    {
    }

void physics::reset(void)
    {
    //set current velocity to zero
    vel_.set(0,0,0);
    //set current acceleration to zero
    accel_.set(0,0,0);
    ygTransform::reset();
    }

void physics::message(const ygMessage& msg)
    {
    //set the velocity
    if (msg == "velocity")
        {
        msg.getVec3Args(vel_);
        }
    //set the acceleration
    else if (msg == "acceleration")
        {
        msg.getVec3Args(accel_);
        }
    else
        ygTransform::message(msg);
    }
    
void physics::app(void)
    {
    pfMatrix mat;
    getMatrix(mat);
    pfCoord coord;
    mat.getOrthoCoord(&coord);
    pfVec3 position = coord.xyz;
    float delta = ygWorld::FrameDeltaTime;
    vel_ += accel_ * delta;
    position += vel_ * delta;
    mat.makeTrans(position[0],position[1],position[2]);
    setMatrix(mat);
    ygTransform::app();
    }
