// Description: a boolean node that computes the NOT of its last child
//
//<b>notes:</b>
//<ul>
//<li> derived nodes inherit all messages from their base classes
//<li> see reset method for default settings
//<li> all children must be value nodes
//<li> child value nodes of any size can be used
//<li> see the <a href="value.html">value</a> node for more information
//</ul>
//
// Category: Math
// Author: Alex Hill
// Revision: 11/01/01
//
#include "not.h"

extern "C" ygNode* construct_not(const char* name,bool master) { return new not(name,master); }

not::not(const char* name,bool master) : boolean(name,master)
	{
	setClassName("not");
	}

void not::app(void)
	{
	//if this node has size greater than zero and children
	if (size > 0 && numChildren() > 0 && child(numChildren()-1) && child(numChildren()-1)->isOfClass("value"))
		{
		value* currChild = (value*)child(numChildren()-1);
		int currSize = currChild->getSize();
		//for each value in the last child node do
		for (int j=0;j<currSize;j++)
			{
			//if the element is less than the size of this node then
			if (j < size)
				{
				//if the child value is TRUE set the element value to FALSE
				if (currChild->getValue(j) == 1.0)
					values[j] = 0.0;
				//else, set the element value to TRUE
				else
					values[j] = 1.0;
				}
			}
		}
	boolean::app();
	}
