// Description: a value node that computes the negative of its last child
//
//<b>notes:</b>
//<ul>
//<li> derived nodes inherit all messages from their base classes
//<li> see reset method for default settings
//<li> all children must be value nodes
//<li> child value nodes of any size can be used
//<li> see the <a href="value.html">value</a> node for more information
//</ul>
//
// Category: Math
// Author: Alex Hill
// Revision: 11/01/01
//
#include "negate.h"

extern "C" ygNode* construct_negate(const char* name,bool master) { return new negate(name,master); }

negate::negate(const char* name,bool master) : value(name,master)
	{
	setClassName("negate");
	}

void negate::app(void)
	{
	//if this node has size greater than zero and has children
	if (size > 0 && numChildren() > 0 && child(numChildren()-1) && child(numChildren()-1)->isOfClass("value"))
		{
		value* currChild = (value*)child(numChildren()-1);
		int currSize = currChild->getSize();
		//for each value in the last child node do
		for (int j=0;j<currSize;j++)
			{
			//if the element is less than the size of this node then
			if (j < size)
				{
				//set the element value to the negative of the child value
				values[j] = -(currChild->getValue(j));
				}
			}
		}
	value::app();
	}
