#ifndef _movieSurface_h_
#define _movieSurface_h_

#include <Performer/pr/pfString.h>
#include <Performer/pf/pfGeode.h>
#include <Performer/pr/pfGeoSet.h>
#include <Performer/pr/pfGeoState.h>
#include <Performer/pr/pfMaterial.h> 
#include <Performer/pr/pfTexture.h>
#include <Performer/pf/pfGroup.h>
#include <Performer/pf/pfNode.h>
#include <Performer/pf/pfDCS.h>
#include <Performer/pf/pfSCS.h>
#include <Performer/pfdu.h>

#include "ygNode.h"
#include "ygNodeDB.h"
#include "ygWorld.h"
#include "ygNetKeys.h"
#include "ygUser.h"
#include "ygSpace.h"

#include "rectSurface.h"


class movieSurface : public rectSurface 
{
	public:
   		movieSurface(const char* name, bool master=false);   
   		~movieSurface();
  		virtual void message(const ygMessage&);
   		virtual void app(void);
   		virtual void reset(void);

   		void stopMovie();
   		void playMovie();
	protected:
   		virtual void acceptNetKey(const ygString&);
	private:
   		struct _movieSurfacePrivateData *_p;
};
 

extern "C" ygNode* construct_movieSurface(const char*,bool);
 
 
#endif



