// Description: creates a polygon and maps a movie file to its surface
//
//<b>notes:</b>
//<ul>
//<li> all parent node messages are inherited
//<li> see reset method for default settings
//<li> the Quicktime (*.mov) photoJPEG format is only supported on Linux and requires the openquicktime library
//<li> you must add the following to your RUN file in order to use this node on Linux:
//<ul>
//<li> setenv LD_LIBRARY_PATH /usr/local/lib
//</ul>
//
// Category: Deprecated
// Author: Dave Pape
//           11/10/01
// Revision: 01/10/03 Alex Hill - added Linux support
//
#include <malloc.h>
#include <Performer/pf/pfSwitch.h>
#include <Performer/pf/pfGeode.h>
#include <Performer/pr/pfGeoSet.h>
#include <Performer/pr/pfTexture.h>
#include "ygUtil.h"
#include "ygWorld.h"
#include "ygNetKeys.h"
#include "movieScreen.h"
#include "movieObject.h"


using namespace std;

extern "C" ygNode* construct_movieScreen(const char* name,bool master) { return new movieScreen(name,master); }

struct _movieScreenPrivateData
	{
	pfGeoState* gstate;
	pfTexture* texture;
	pfSwitch* sw;
	bool active;
	float startTime;
	int width;
	int height;
	float rate;
	unsigned char* buffer; 
	movieObject movie;
	ygString netFile;
	};

movieScreen::movieScreen(const char* name,bool master) : ygNode(name,master)
	{
	setClassName("movieScreen",true);
	p_ = new struct _movieScreenPrivateData;
	p_->sw = new pfSwitch;
	pfnode()->addChild(p_->sw);
	createGeode();
	p_->sw->setTravMask(PFTRAV_ISECT, YG_ISECT_ALLMASK,PFTRAV_SELF|PFTRAV_DESCEND|PFTRAV_IS_CACHE, PF_SET);
	addNetKey("file",&p_->netFile,YG_NET_STRING);
	hide();
	}

movieScreen::~movieScreen(void)
	{
	delete p_;
	}


void movieScreen::reset(void)
	{
	ygNode::reset();
	}


void movieScreen::message(const ygMessage& msg)
	{
	if (msg == "show")
		{
		if (msg.args.size() == 1)
			show(msg.args[0]);
		else
			msg.error(name(), "(wrong number of arguments)");
		}
	else if (msg == "hide")
		hide();
	else
		ygNode::message(msg);
	}


void movieScreen::show(const ygString& file)
	{
	char *searchPath = ".";
	ygString fullPath;
	if (getenv("YG_PATH"))
		searchPath = getenv("YG_PATH");
	if (!ygFindFile(file,searchPath,fullPath))
		{
		fprintf(stderr,"ERROR: movieScreen::show: could not find file '%s'\n",file.c_str());
		return;
		}
	if (p_->movie.isOpen())
		p_->movie.close();
	p_->movie.open(fullPath.c_str());
	if (!p_->movie.isOpen())
		{
		fprintf(stderr,"ERROR (movieScreen::show): failed to open '%s'\n",fullPath.c_str());
		return;
		}
	p_->width = p_->movie.getWidth();
	p_->height = p_->movie.getHeight();
	p_->rate = p_->movie.getRate();
	p_->buffer = (unsigned char*)pfMalloc(p_->width*p_->height*4*sizeof(unsigned char),pfGetSharedArena());

	p_->sw->setVal(PFSWITCH_ON);
	p_->active = true;
	p_->startTime = ygWorld::FrameTime;
	eventOccurred("start");
	p_->netFile = file;
	netKeyChanged("file");
	}


void movieScreen::hide(void)
	{
	p_->sw->setVal(PFSWITCH_OFF);
	if (p_->movie.isOpen())
		p_->movie.close();
	p_->active = false;
	eventOccurred("stop");
	p_->netFile.clear();
	netKeyChanged("file");
	}


void movieScreen::app(void)
	{
	if (p_->active)
		{
		int frame = (ygWorld::FrameTime - p_->startTime)*p_->rate;		
		if (p_->movie.getFrame(frame,p_->buffer))
			{
			p_->texture->setFormat(PFTEX_IMAGE_FORMAT, GL_ABGR_EXT);
			p_->texture->setImage((uint*)p_->buffer,4,p_->width,p_->height,1);
			}
		else
			{
			p_->movie.close();
			p_->active = false;
			eventOccurred("stop");
			}
		}
	ygNode::app();
	}


void movieScreen::createGeode(void)
	{
	pfVec3 *verts;
	pfVec4 *color;
	pfVec2 *texc;
	pfGeoSet *gset;
	pfGeode *geode;
	int numVerts = 4;
	verts = (pfVec3*) pfMalloc(numVerts*sizeof(pfVec3),pfGetSharedArena());
	color = (pfVec4*) pfMalloc(sizeof(pfVec4),pfGetSharedArena());
	texc = (pfVec2*) pfMalloc(numVerts*sizeof(pfVec2),pfGetSharedArena());
	verts[0].set(0, 0, 0);
	verts[1].set(1.3, 0, 0);
	verts[2].set(1.3, 0, 1);
	verts[3].set(0, 0, 1);
	texc[0].set(0, 0);
	texc[1].set(1, 0);
	texc[2].set(1, 1);
	texc[3].set(0, 1);
	color[0].set(1, 1, 1, 1);
	p_->gstate = new pfGeoState;
	p_->texture = new pfTexture;
	p_->gstate->setAttr(PFSTATE_TEXTURE,p_->texture);
	p_->gstate->setMode(PFSTATE_ENTEXTURE,PF_ON);
	p_->gstate->setMode(PFSTATE_ENLIGHTING,PF_OFF);
	gset = new pfGeoSet;
	gset->setPrimType(PFGS_QUADS);
	gset->setNumPrims(1);
	gset->setAttr(PFGS_COORD3, PFGS_PER_VERTEX,verts,NULL);
	gset->setAttr(PFGS_COLOR4, PFGS_OVERALL,color,NULL);
	gset->setAttr(PFGS_TEXCOORD2, PFGS_PER_VERTEX,texc,NULL);
	gset->setGState(p_->gstate);
	geode = new pfGeode;
	geode->addGSet(gset);
	p_->sw->addChild(geode);
	}


void movieScreen::acceptNetKey(const ygString& key)
	{
	if (key == "file")
		{
		if (p_->netFile.length() <= 0)
			hide();
		else
			show(p_->netFile);
		}
	else
		ygNode::acceptNetKey(key);
	}
	

	
	
	
