#include <malloc.h>

#ifdef __sgi

#include <dmedia/moviefile.h>

class movieObject
	{
	public:
	 movieObject(void);
	 ~movieObject(void);
	 void open(const ygString&);
	 void close(void);
	 bool getFrame(int,unsigned char*);
	 bool isOpen(void);
	 int getWidth(void);
	 int getHeight(void);
	 int getLength(void);
	 int getRate(void);
	private:
	 MVid movie;
	 MVid track;
	 int length;
	 int width;
	 int height;
	 int rate;
	 unsigned char *yuv[3]; 
	};
	
movieObject::movieObject(void)
	{
	movie = NULL;
	track = NULL;
	length = 0;
	width = 0;
	height = 0;
	rate = 0;
	}
	
movieObject::~movieObject(void)
	{
	close();
	}

void movieObject::open(const ygString& file)
	{
	close();
	mvOpenFile(file.c_str(),O_RDONLY,&movie);
	mvFindTrackByMedium(movie,DM_IMAGE,&track);
	if (movie && track)
		{
		width = mvGetImageWidth(track);
		height = mvGetImageHeight(track);
		rate = mvGetImageRate(track);
		length = (int)mvGetTrackDuration(track,rate);
		yuv[0] = (unsigned char*)malloc(width*height*sizeof(unsigned char));
		yuv[1] = (unsigned char*)malloc((width/2)*(height/2)*sizeof(unsigned char));
		yuv[2] = (unsigned char*)malloc((width/2)*(height/2)*sizeof(unsigned char));
		}
	}

void movieObject::close(void)
	{
	if (movie)
		mvClose(movie);
	movie = NULL;
	}

bool movieObject::getFrame(int frame,unsigned char* buffer)
	{
	if (movie && frame < length)
		{
		mvReadFrames(track,frame,1,width*height*sizeof(unsigned char),buffer);
		return true;
		}
	return false;
	}
	
#else	
	
#include <openquicktime/openquicktime.h>
#include <openquicktime/colormodels.h>

class movieObject
	{
	public:
	 movieObject(void);
	 ~movieObject(void);
	 void open(const ygString&);
	 void close(void);
	 bool getFrame(int,unsigned char*);
	 bool isOpen(void);
	 int getWidth(void);
	 int getHeight(void);
	 int getLength(void);
	 int getRate(void);
	private:
	 quicktime_t* movie;
	 int length;
	 int width;
	 int height;
	 int rate;
	 unsigned char *yuv[3]; 
	};
	
movieObject::movieObject(void)
	{
	movie = NULL;
	length = 0;
	width = 0;
	height = 0;
	rate = 0;
	}
	
movieObject::~movieObject(void)
	{
	close();
	}

void movieObject::open(const ygString& file)
	{
	close();
	movie = quicktime_open(file.c_str(),1,0);
	if (movie)
		{
		width = quicktime_video_width(movie,0);
		height = quicktime_video_height(movie,0);
		rate = quicktime_frame_rate(movie,0);
		length = quicktime_video_length(movie,0);
		yuv[0] = (unsigned char*)malloc(width*height*sizeof(unsigned char));
		yuv[1] = (unsigned char*)malloc((width/2)*(height/2)*sizeof(unsigned char));
		yuv[2] = (unsigned char*)malloc((width/2)*(height/2)*sizeof(unsigned char));
		}
	}

void movieObject::close(void)
	{
	if (movie)
		quicktime_close(movie);
	movie = NULL;
	}

bool movieObject::getFrame(int frame,unsigned char* buffer)
	{
	
	if (movie && frame < length)
		{
		quicktime_set_video_position(movie,frame,0);
		quicktime_decode_video(movie,BC_YUV420P,yuv,0);
	
		double y,u,v;
		double r,g,b;
		for (int i=0;i<height;i++)
			{
			for (int j=0;j<width;j++)
				{
				int ir = height-1-i;
				int ir2 = ir/2;
				int j2 = j/2;
				y = (double)yuv[0][ir*width+j];
				u = (double)yuv[1][ir2*width/2+j2];
				v = (double)yuv[2][ir2*width/2+j2];
			
				// convert color space
				r = 1 * y -  0.0009267*(u-128) + 1.4016868*(v-128);
				g = 1 * y -  0.3436954*(u-128) - 0.7141690*(v-128);
				b = 1 * y +  1.7721604*(u-128) + 0.0009902*(v-128);
			
				buffer[(i*width*4)+(j*4)] = 255;
				buffer[(i*width*4)+(j*4)+1] = (unsigned char) (b>255)?255:((b<0)?0:b);
				buffer[(i*width*4)+(j*4)+2] = (unsigned char) (g>255)?255:((g<0)?0:g);
				buffer[(i*width*4)+(j*4)+3] = (unsigned char) (r>255)?255:((r<0)?0:r);
				}
			}
		return true;
		}
			
	return false;
	}

#endif

bool movieObject::isOpen(void)
	{
	if (movie)
		return 1;
	return 0;
	}

int movieObject::getWidth(void)
	{
	return width;
	}

int movieObject::getHeight(void)
	{
	return height;
	}

int movieObject::getLength(void)
	{
	return length;
	}

int movieObject::getRate(void)
	{
	return rate;
	}
	
