// Description: a mover that takes end coordinates from a node
//
//<b>notes:</b>
//<ul>
//<li> derived nodes inherit all messages from their base classes
//<li> see reset method for default settings
//<li> the node message can also indicate a user head, wand, or body
//</ul>
//
// Category: Transformation
// Author: Alex Hill
// Revision: 11/01/01
//
#include <ygNodeDB.h>
#include <ygUser.h>
#include "moveToNode.h"

extern "C" ygNode* construct_moveToNode(const char* name,bool master) { return new moveToNode(name,master); }

moveToNode::moveToNode(const char* name,bool master) : mover(name,master)
	{
	setClassName("moveToNode");
	node = NULL;
	}

moveToNode::~moveToNode(void)
	{
	}

void moveToNode::reset(void)
	{
	//clear node name
	node = NULL;
	mover::reset();
	}

void moveToNode::message(const ygMessage& msg)
	{
	//clear or set the node and optional user body part
	if (msg == "node")
		{
		//if number of arguments is greater than zero
		if (msg.args.size() > 0)
			{
			node = ygNodeDB::find(msg.args[0]);
			//if node type is user then
			if (msg.args.size() > 1 && node && node->isOfClass("ygUser"))
				{
				ygUser* user = (ygUser*)node;
				//if second argument is "head"
				if (msg.args[1] == "head")
					{
					//set node to user head
					if (user->head())
						node = user->head();
					}
				//if second argument is "body"
				else if (msg.args[1] == "body")
					{
					//for each user child
					for (int i=0; i<user->numChildren(); i++)
						{
						ygNode* currNode = user->child(i);
						//if child is of type body then set node
						if (currNode->isOfClass("body"))
							node = currNode;
						}
					}
				//if second argument is "wand"
				else if (msg.args[1] == "wand")
					{
					//if user has a wand then
					if (user->wand(0))
						{
						//use specified wand number or default to zero
						if (msg.args.size() > 2)
							node = user->wand(msg.intArg(1));
						else
							node = user->wand(0);
						}
					}
				else
					node = user;
				}
			}
		//else, clear the node name
		else
			node = NULL;
		}
	else
		mover::message(msg);
	}


void moveToNode::app(void)
	{
	if (node)
		{
		endPosQuat.pos = node->origin(parent());
		pfMatrix mat;
		node->getTransform(mat);
		mat.getOrthoQuat(endPosQuat.quat);
		}
	mover::app();
	}
