#ifndef _morpher_h_
#define _morpher_h_

#include <list>
#include <Performer/pr/pfList.h>
#include <Performer/pf/pfGeode.h>
#include <Performer/pr/pfGeoState.h>
#include <Performer/pr/pfMaterial.h>
#include "ygNode.h"

class morpher : public ygNode
	{
	public:
	 morpher(const char* name,bool master=true);
	 virtual void reset(void);
	 virtual void message(const ygMessage&);
	 virtual void app(void);
	 void addModel(const ygString&);
	 void setFrame(int);
	 void setPosition(float);
	private:
	 pfList* keyframes;
	 pfList* fluxDataList;
	 pfGeode* geode;
	 int numFrames;
	 int frame;
	 float position;
	 ygString filenames;
	 pfFlux* fluxFrame;
	 void getGeoSetData(pfNode*,pfList*);
	 void copyModelToGeode(pfNode*);
	 void updateBounds();
	 void copyGeoSet(pfGeoSet*);
	protected:
	 virtual void acceptNetKey(const ygString&);
	};

#endif
