// Description: a value node that performs common mathematic operations
//
//<b>notes:</b>
//<ul>
//<li> derived nodes inherit all messages from their base classes
//<li> see reset method for default settings
//<li> see the <a href="value.html">value</a> node for more information
//</ul>
//
// Category: Math
// Author: Alex Hill
// Revision: 11/01/02
//
#include "mathematics.h"

extern "C" ygNode* construct_mathematics(const char* name,bool master) { return new mathematics(name,master); }

mathematics::mathematics(const char* name,bool master) : interpolate(name,master)
	{
	setClassName("mathematics");
	}

void mathematics::message(const ygMessage& msg)
	{
	//set a single array element to the absolute value of the input
	if (msg == "abs")
		{
		if (msg.args.size() > 0)
			{
			float newValue = msg.floatArg(0);
			if (msg.args.size() > 1) 
				{
				int element = msg.intArg(1);
				if (element >= 0)
					{	
					if (element >= size)
						setValueSize(element+1);
					setInterpolate(fabs(newValue),element);
					}
				else
					msg.error(name(),"(index out of range)");
				}
			else
				{
				for (int i=0;i<size;i++)
					setInterpolate(fabs(newValue),i);
				}
			}
		else
			msg.error(name(),"(wrong number of arguments)");
		}
	//set a single array element to the sine of the input
	else if (msg == "sin")
		{
		if (msg.args.size() > 0)
			{
			float newValue = msg.floatArg(0);
			if (msg.args.size() > 1) 
				{
				int element = msg.intArg(1);
				if (element >= 0)
					{	
					if (element >= size)
						setValueSize(element+1);
					setInterpolate(sinf(newValue),element);
					}
				else
					msg.error(name(),"(index out of range)");
				}
			else
				{
				for (int i=0;i<size;i++)
					setInterpolate(sinf(newValue),i);
				}
			}
		else
			msg.error(name(),"(wrong number of arguments)");
		}
	//set a single array element to the cosine of the input
	else if (msg == "cos")
		{
		if (msg.args.size() > 0)
			{
			float newValue = msg.floatArg(0);
			if (msg.args.size() > 1) 
				{
				int element = msg.intArg(1);
				if (element >= 0)
					{	
					if (element >= size)
						setValueSize(element+1);
					setInterpolate(cosf(newValue),element);
					}
				else
					msg.error(name(),"(index out of range)");
				}
			else
				{
				for (int i=0;i<size;i++)
					setInterpolate(cosf(newValue),i);
				}
			}
		else
			msg.error(name(),"(wrong number of arguments)");
		}
	//set a single array element to the square root of the positive input
	else if (msg == "sqrt")
		{
		if (msg.args.size() > 0)
			{
			float newValue = msg.floatArg(0);
			if (newValue >= 0.0)
				{
				if (msg.args.size() > 1) 
					{
					int element = msg.intArg(1);
					if (element >= 0)
						{	
						if (element >= size)
							setValueSize(element+1);
						setInterpolate(sqrt(newValue),element);
						}
					else
						msg.error(name(),"(index out of range)");
					}
				else
					{
					for (int i=0;i<size;i++)
						setInterpolate(sqrt(newValue),i);
					}
				}
			}
		else
			msg.error(name(),"(wrong number of arguments)");
		}
	//set a single array element to a random number
	else if (msg == "rand")
		{
		if (msg.args.size() < 2)
			{
			if (msg.args.size() == 1) 
				{
				int element = msg.intArg(0);
				if (element >= 0)
					{	
					if (element >= size)
						setValueSize(element+1);
					setInterpolate(drand48(),element);
					}
				else
					msg.error(name(),"(index out of range)");
				}
			else
				{
				for (int i=0;i<size;i++)
					setInterpolate(drand48(),i);
				}
			}
		else
			msg.error(name(),"(wrong number of arguments)");
		}
	else
		interpolate::message(msg);
	}
