// Description: a transform that orients the model to face the user
//
//<b>notes:</b>
//<ul>
//<li> derived nodes inherit all messages from their base classes
//<li> see reset method for default settings
//<li> the object front is assumed to be the Z-axis
//<li> this is a less flexible version of <a href="billboard.html">billboard</a> 
//</ul>
//
// Category: Deprecated
// Author: Alex Hill
// Revision: 11/01/01
//
#include <ygUser.h>
#include <ygWorld.h>
#include "lookAtUser.h"

extern "C" ygNode* construct_lookAtUser(const char* name,bool master) { return new lookAtUser(name,master); }

lookAtUser::lookAtUser(const char* name,bool master) : ygNode(name,master)
{
	setClassName("lookAtUser",true);
	dcs = new pfDCS;
	setPfNode(dcs);
}

void lookAtUser::reset(void)
{
	ygNode::reset();
}


void lookAtUser::message(const ygMessage& msg)
{
	ygNode::message(msg);
}


void lookAtUser::app(void)
{
	// get user position
	pfVec3 userPos, objectFront(0, 0, 1);

	ygNode * viewer = ygWorld::World->viewer();
	if (viewer) userPos = viewer->origin(parent()); 
	userPos.normalize();

	// get orientation of this object to face the user
	pfMatrix matrix;
	matrix.makeVecRotVec(objectFront, userPos);
	dcs->setMat(matrix);

	ygNode::app();
}
