// Description: a selector that rotates through the sequence in a fixed duration
//
//<b>notes:</b>
//<ul>
//<li> derived nodes inherit all messages from their base classes
//<li> see reset method for default settings
//<li> clients are not guarenteed to be selecting the same child at any time
//<li> this node can also be implemented with a <a href="timer.html">timer</a> node
//</ul>
//
// Category: Selection
// Author: Dave Pape
// Revision: 11/01/01
//
#include <Performer/pf/pfSwitch.h>
#include <ygNetKeys.h>
#include <ygWorld.h>
#include "localFlipbook.h"

using namespace std;

extern "C" ygNode* construct_localFlipbook(const char* name,bool master) { return new localFlipbook(name,master); }


#define ACTIVE_NETKEY "act"
#define DURATION_NETKEY "dur"


localFlipbook::localFlipbook(const char* name,bool master) : ygNode(name,master,false)
	{
	setClassName("localFlipbook");
	switch_ = new pfSwitch;
	setPfNode(switch_);
	addNetKey(DURATION_NETKEY, &duration_, YG_NET_FLOAT);
	addNetKey(ACTIVE_NETKEY, &active_, YG_NET_BOOL);
	}

void localFlipbook::reset(void)
	{
	//reset the first frame flag
	firstFrame_ = true;
	//set duration to 1.0
	duration_ = 1.0;
	//set active to false
	active_ = false;
	startTime_ = 0.0;
	ygNode::reset();
	}


void localFlipbook::message(const ygMessage& msg)
	{
	//set the duration of the sequence
	if (msg == "duration")
		{
		duration_ = msg.floatArg(0);
		netKeyChanged(DURATION_NETKEY);
		}
	//set active mode
	else if (msg == "active")
		{
		active_ = msg.boolArg(0);
		netKeyChanged(ACTIVE_NETKEY);
		}
	//start the sequence
	else if (msg == "start")
		{
		start();
		}
	//stop the sequence
	else if (msg == "stop")
		{
		stop();
		}
	else
		ygNode::message(msg);
	}

void localFlipbook::start(void)
	{
	//if not active
	if (!active_)
		{
		//set active to true
		active_ = true;
		//set start time
		startTime_ = ygWorld::FrameTime;
		//update the distributed active flag
		netKeyChanged(ACTIVE_NETKEY);
		}
	}

void localFlipbook::stop(void)
	{
	//if active then set active to false
	if (active_)
		{
		active_ = false;
		//update the distributed active flag
		netKeyChanged(ACTIVE_NETKEY);
		}
	}

void localFlipbook::app(void)
	{
	//if first frame then select first item
	if (firstFrame_)
		{
		switch_->setVal(0);
		firstFrame_ = false;
		}
	//if active
	if (active_) 
		{
		int v, max = numChildren();
		float t;
		//divide elapsed time by duration
		t = (ygWorld::FrameTime - startTime_) / duration_;
		//convert to integer
		t -= (int) t;
		v = (int) (t * max);
		if (v >= max)
			v = max - 1;
		//set selector
		switch_->setVal(v);
		}

	ygNode::app();
	}
