// Description: a switch that is only turned on for the host site
//
//<b>notes:</b>
//<ul>
//<li> derived nodes inherit all messages from their base classes
//<li> see reset method for default settings
//<li> this node can be used to hide geometry, sounds, and triggers from remote users
//</ul>
//
// Category: Selection
// Author: Dave Pape
// Revision: 11/01/01
//
#include <Performer/pf/pfSwitch.h>
#include "localData.h"

using namespace std;

extern "C" ygNode* construct_localData(const char* name,bool master) { return new localData(name,master); }


localData::localData(const char* name,bool master) : ygNode(name,master)
	{
	setClassName("localData",true);
	pfSwitch * sw = new pfSwitch;
	setPfNode(sw);
	if (master)
		sw->setVal(PFSWITCH_ON);
	else
		sw->setVal(PFSWITCH_OFF);
	}
