// Description: set the heirerchy for rendering of coplanar surfaces
//
//<b>notes:</b>
//<ul>
//<li> derived nodes inherit all messages from their base classes
//<li> see reset method for default settings
//<li> creates a layer using a Performer pfLayer
//<li> this node is very helpful for drwaing coplanar surface without flimmering
//<ul>
//<li> the mode function is used to specify which hardware mechanism to
//<li>   use for drwaing,and specified by the following "type" options
//<li> The displace mode offers the best performance of layer.
//<li> The stencil mode offers the best image quality
//<li> The fast mode produces the fastest, but nor necessarily the highest quality, decaling.
//<li> The quality mode produces the highest quality, but not necessarily the fastest, decaling.
//</ul>
//</ul>
//
// Category: Attributes
// Author: Kapil Arora
// Revision: 10/04/04
//

#include <ygWorld.h>
#include "layer.h"
#include "ygNetKeys.h"
#include "ygNodeDB.h"
#include "ygString.h"
#include <Performer/pf/pfLayer.h>


using namespace std;

extern "C" ygNode* construct_layer(const char* name,bool master) { return new layer(name,master); }


layer::layer(const char* name,bool master) : ygNode(name,master)
	{
	setClassName("layer",true);
	sw = new pfLayer;
	setPfNode(sw);
	addNetKey("mode",&mode, YG_NET_INT);
	addNetKey("base",&base_name, YG_NET_STRING);
	}

layer::~layer(void)
	{
	}

void layer::reset(void)
	{
	//set mode to fast
	sw->setMode(PFDECAL_BASE_FAST);
	//reset first child to base layer
	for (int i=0;i<numChildren();i++)
		{
		if(i == 0)
			sw->setBase(child(i)->pfnode());
		else
			sw->setDecal(child(i)->pfnode());
		}
	ygNode::reset();
	}

void layer::makeDecalLayer(ygNode *child)
	{
	//set the Decal Layer
	sw->setDecal(child->pfnode());
	}

void layer::message(const ygMessage& msg)
	{
	//set the mode for drawing child 
	if (msg == "mode")
		{
		if (msg.args.size() == 1)
			{
			if(msg.args[0] == "stencil")
				{
				mode=PFDECAL_BASE_STENCIL;
				sw->setMode(mode);
				netKeyChanged("mode");
				}
			else if(msg.args[0] == "fast")
				{
				mode=PFDECAL_BASE_FAST;
				sw->setMode(mode);
				netKeyChanged("mode");
				}
			else if(msg.args[0] == "quality")
				{
				mode=PFDECAL_BASE_HIGH_QUALITY;
				sw->setMode(mode);
				netKeyChanged("mode");
				}
			else if(msg.args[0] == "displace")
				{
				mode=PFDECAL_BASE_DISPLACE|PFDECAL_LAYER_OFFSET;
				sw->setMode(mode);
				netKeyChanged("mode");
				}
			}
		else
			msg.error(name(),"(wrong number of arguments)");
    		}
	//set the layer as a Base Layer
	else if (msg =="base")
		{
		if(msg.args.size()>0)
			{
			ygNode* node;
			node = ygNodeDB::find(msg.args[0]);
			if(node)
				{
				for (int i=0;i<numChildren();i++)
					{
					ygString child_name = child(i)->name();
					if(child_name.contains(msg.args[0]))
						{
						base_name = child_name;
						sw->setBase(child(i)->pfnode());
						netKeyChanged("base");
						}
					else
						makeDecalLayer(child(i));
					}					
				}					
			else 
				msg.error(name(),"(wrong number of arguments)");				
			}	
		else
			msg.error(name(),"(wrong number of arguments)");
		}
	else
		ygNode::message(msg);	
	}






void layer::acceptNetKey(const ygString& key)
	{
	if (key == "mode" )
		sw->setMode(mode);
	else if (key == "base")
		{
		for (int i=0;i<numChildren();i++)
			{
			if(base_name.contains(child(i)->name()))
				{
				sw->setBase(child(i)->pfnode());
				}
			}
		}
	else
		ygNode::acceptNetKey(key);
	}
