// Description: creates events from keyboard input
//
//<b>notes:</b>
//<ul>
//<li> derived nodes inherit all messages from their base classes
//<li> see reset method for default settings
//<li> the keys detected are the alphabet and the ten digits
//</ul>
//
// Category: Trigger
// Author: Dave Pape
// Revision: 11/01/01
//
#include <pfcave.h>
#include "keyboard.h"

extern "C" ygNode* construct_keyboard(const char* name,bool master) { return new keyboard(name,master); }

#define NUMKEYS 36

static struct { CAVEDevice dev; char *label; } keyboardKeys[NUMKEYS] =
	{
	    { CAVE_AKEY, "A" },
	    { CAVE_BKEY, "B" },
	    { CAVE_CKEY, "C" },
	    { CAVE_DKEY, "D" },
	    { CAVE_EKEY, "E" },
	    { CAVE_FKEY, "F" },
	    { CAVE_GKEY, "G" },
	    { CAVE_HKEY, "H" },
	    { CAVE_IKEY, "I" },
	    { CAVE_JKEY, "J" },
	    { CAVE_KKEY, "K" },
	    { CAVE_LKEY, "L" },
	    { CAVE_MKEY, "M" },
	    { CAVE_NKEY, "N" },
	    { CAVE_OKEY, "O" },
	    { CAVE_PKEY, "P" },
	    { CAVE_QKEY, "Q" },
	    { CAVE_RKEY, "R" },
	    { CAVE_SKEY, "S" },
	    { CAVE_TKEY, "T" },
	    { CAVE_UKEY, "U" },
	    { CAVE_VKEY, "V" },
	    { CAVE_WKEY, "W" },
	    { CAVE_XKEY, "X" },
	    { CAVE_YKEY, "Y" },
	    { CAVE_ZKEY, "Z" },
	    { CAVE_ZEROKEY, "0" },
	    { CAVE_ONEKEY, "1" },
	    { CAVE_TWOKEY, "2" },
	    { CAVE_THREEKEY, "3" },
	    { CAVE_FOURKEY, "4" },
	    { CAVE_FIVEKEY, "5" },
	    { CAVE_SIXKEY, "6" },
	    { CAVE_SEVENKEY, "7" },
	    { CAVE_EIGHTKEY, "8" },
	    { CAVE_NINEKEY, "9" }
	};

struct _keyboardPrivateData
	{
	int prevState[NUMKEYS];
	};


keyboard::keyboard(const char* name,bool master) : ygNode(name,master)
	{
	setClassName("keyboard");
	p_ = new struct _keyboardPrivateData;
	}

keyboard::~keyboard(void)
	{
	delete p_;
	}


void keyboard::reset(void)
	{
	int i;
	//set the previous state of all keys to 0
	for (i=0; i < NUMKEYS; i++)
		p_->prevState[i] = 0;
	ygNode::reset();
	}


void keyboard::app(void)
	{
	int i;
	//for each possible key
	for (i=0; i < NUMKEYS; i++)
		{
		int state = CAVEgetbutton(keyboardKeys[i].dev);
		//if the state has changed then generate a key event
		if (state && (!p_->prevState[i]))
			{
			ygString event(keyboardKeys[i].label);
			event += "key";
			//the key concatenated with the word "key" (i.e. akey, 1key)
			eventOccurred(event);
			}
		p_->prevState[i] = state;
		}
	ygNode::app();
	}
