// Description: adds highlighting to the nodes below it
//
//<b>notes:</b>
//<ul>
//<li> derived nodes inherit all messages from their base classes
//<li> see reset method for default settings
//</ul>
//
// Category: attributes
// Author: Alex Hill
// Revision: 11/01/01
//
#include <Performer/pf/pfGroup.h>
#include <Performer/pr/pfGeoSet.h>
#include <Performer/pf/pfGeode.h>
#include <ygNetKeys.h>
#include "highlight.h"

extern "C" ygNode* construct_highlight(const char* name,bool master) { return new highlight(name,master); }

highlight::highlight(const char* name,bool master) : ygNode(name,master)
	{
	setClassName("highlight",true);
	highlight_ = new pfHighlight;
	active = true;
	mode = PFHL_LINES;
	highlight_->setMode(mode);
	color.set(1,1,1,1);
	highlight_->setColor(PFHL_FGCOLOR,color[0],color[1],color[2]);
	highlight_->setAlpha(color[3]);
	size[0] = 1.0;
	size[1] = 1.0;
	highlight_->setPntSize(size[0]);
	highlight_->setLineWidth(size[0]);
	highlight_->setNormalLength(0.0,size[1]);
	addNetKey("active",&active,YG_NET_BOOL);
	addNetKey("color",&color,YG_NET_VEC4);
	addNetKey("mode",&mode,YG_NET_INT);
	addNetKey("size",&size,YG_NET_VEC2);
	}

highlight::~highlight(void)
	{
	}


void highlight::reset(void)
	{
	//set active to true
	active = true;
	//set the highlight mode to lines
	mode = PFHL_LINES;
	highlight_->setMode(mode);
	//set the highlight color to white
	color.set(1,1,1,1);
	highlight_->setColor(PFHL_FGCOLOR,color[0],color[1],color[2]);
	highlight_->setAlpha(color[3]);
	//set the highlight width to 1.0
	size[0] = 1.0;
	//set the highlight normal length to 1.0
	size[1] = 1.0;
	highlight_->setPntSize(size[0]);
	highlight_->setLineWidth(size[0]);
	highlight_->setNormalLength(0.0,size[1]);
	ygNode::reset();
	}


void highlight::message(const ygMessage& msg)
	{
	//include any combination of options
	if (msg == "mode")
		{
		if (msg.args.size() > 0)
			{
			uint mode = 0;
			for (int i=0;i<msg.args.size();i++)
				{
				if (msg.args[i] == "points")
					mode |= PFHL_POINTS;
				else if (msg.args[i] == "lines")
					mode |= PFHL_LINES;
				else if (msg.args[i] == "normals")
					mode |= PFHL_NORMALS;
				else if (msg.args[i] == "bbox")
					mode |= PFHL_BBOX_LINES;
				else if (msg.args[i] == "fill")
					mode |= PFHL_FILL;
				}
			if (mode)
				setMode(mode);
			else
				setMode(PFHL_LINES);
			}
		else
			setMode(PFHL_LINES);
		}
	//set the color with or without alpha
	else if (msg == "color")
		{
		pfVec4 color;
		if (msg.args.size() == 3)
			{
			pfVec3 temp;
			msg.getVec3Args(temp);
			pfVec4 value;
			value[0] = temp[0];
			value[1] = temp[1];
			value[2] = temp[2];
			value[3] = 1.0;
			setColor(value);
			}
		else if (msg.args.size() == 4)
			{
			pfVec4 value;
			msg.getVec4Args(value);
			setColor(value);
			}
		else
			msg.error(name(),"(wrong number of arguments)");
		}
	//set the line width and point size
	else if (msg == "width")
		{
		if (msg.args.size() == 1)
			{
			pfVec2 value;
			value[0] = msg.floatArg(0);
			value[1] = size[1];			
			setSize(value);
			}
		else
			msg.error(name(),"(wrong number of arguments)");
		}
	//set the length of normals
	else if (msg == "length")
		{
		if (msg.args.size() == 1)
			{
			pfVec2 value;
			value[0] = size[0];
			value[1] = msg.floatArg(0);			
			setSize(value);
			}
		else
			msg.error(name(),"(wrong number of arguments)");
		}
	//turn highlighting on
	else if (msg == "on")
		{
		if (msg.args.size() == 0)
			setActive(true);
		else
			msg.error(name(),"(wrong number of arguments)");
		}
	//turn highlighting off
	else if (msg == "off")
		{
		if (msg.args.size() == 0)
			setActive(false);
		else
			msg.error(name(),"(wrong number of arguments)");
		}
	else
		ygNode::message(msg);
	}

void highlight::app(void)
	{
	if (pfChanged())
		{
		if (active)
			setGSetHlight(highlight_,pfnode());
		else
			setGSetHlight(NULL,pfnode());
		}
	ygNode::app();
	}

void highlight::setGSetHlight(pfHighlight* hlight,pfNode* node)
    {
    int i;
	//if node type is pfGeode then set geoset properties
    if (node->isOfType(pfGeode::getClassType()))
		{
		pfGeode *geode = (pfGeode *)node;
		//for each geode, call setGeosetTexture
		for (i=0; i < geode->getNumGSets(); i++)
			geode->getGSet(i)->setHlight(hlight);
		}
	//else, if node type is pfGroup
    else if (node->isOfType(pfGroup::getClassType()))
		{
		pfGroup *group = (pfGroup *)node;
		//call this function recursively on all children
		for (i=0; i < group->getNumChildren(); i++)
			setGSetHlight(hlight,group->getChild(i));
		}
    }

void highlight::setActive(bool val)
	{
	active = val;
	if (active)
		setGSetHlight(highlight_,pfnode());
	else
		setGSetHlight(NULL,pfnode());
	netKeyChanged("active");
	}

void highlight::setMode(uint val)
	{
	mode = val;
	highlight_->setMode(mode);
	netKeyChanged("mode");
	}

void highlight::setColor(const pfVec4& val)
	{
	color = val;
	highlight_->setColor(PFHL_FGCOLOR,color[0],color[1],color[2]);
	highlight_->setAlpha(color[3]);
	netKeyChanged("color");
	}

void highlight::setSize(const pfVec2& val)
	{
	size = val;
	highlight_->setPntSize(size[0]);
	highlight_->setLineWidth(size[0]);
	highlight_->setNormalLength(0.0,size[1]);
	netKeyChanged("size");
	}

void highlight::acceptNetKey(const ygString& key)
	{
	if (key == "active")
		setActive(active);
	else if (key == "mode")
		setMode(mode);
	else if (key == "color")
		setColor(color);
	else if (key == "size")
		setSize(size);
	else
		ygNode::acceptNetKey(key);
	}
