// Description: a boolean node that does a > test on its children
//
//<b>notes:</b>
//<ul>
//<li> derived nodes inherit all messages from their base classes
//<li> see reset method for default settings
//<li> all children must be value nodes
//<li> child value nodes of any size can be used
//<li> see the <a href="value.html">value</a> node for more information
//</ul>
//
// Category: Math
// Author: Alex Hill
// Revision: 11/01/01
//
#include "greaterThan.h"

extern "C" ygNode* construct_greaterThan(const char* name,bool master) { return new greaterThan(name,master); }

greaterThan::greaterThan(const char* name,bool master) : boolean(name,master)
	{
	setClassName("greaterThan");
	}

void greaterThan::app(void)
	{
	//if this node has size greater than zero
	if (size > 0)
		{
		int currNumChildren = numChildren();
		value* currChild = NULL;
		value* lastChild;
		int currSize = 0;
		int lastSize;
		//for each child node do
		for (int i=0;i<currNumChildren;i++)
			{
			if (child(i) && child(i)->isOfClass("value"))
				{
				lastChild = currChild;
				currChild = (value*)child(i);
				lastSize = currSize;
				currSize = currChild->getSize();
				//for each value in the child node do
				for (int j=0;j<currSize;j++)
					{
					//if the element is less than the size of this node then
					if (j < size)
						{
						//if the first child tested, initialize the element value to TRUE
						if (j >= lastSize)
							values[j] = 1.0;
						//set the element value to FALSE if the child value is not greater than the prior
						else if (lastChild->getValue(j) <= currChild->getValue(j))
							values[j] = 0.0;
						}
					}
				}
			}
		}
	boolean::app();
	}
