#ifndef _fltTransform_h_
#define _fltTransform_h_

#include <Performer/pr/pfLinMath.h>
#include "ygNode.h"


class fltTransform : public ygNode
	{
	public:
	 fltTransform(const char*,bool master=true);
	 ~fltTransform(void);
	 virtual void reset(void);
	 virtual void message(const ygMessage&);
	 void extractTransform(const ygString&,const ygString&,const int&);
	 void getMatrix(pfMatrix&) const;
	 void setMatrix(pfMatrix&);
	 void setPosition(float x,float y,float z);
	 void setOrientation(float x,float y,float z);
	 void setSize(float s);
	 void setSize(float sx,float sy,float sz);
	 inline	 void setPosition(pfVec3 v) { setPosition(v[0],v[1],v[2]); }
	 inline	 void setOrientation(pfVec3 v) {setOrientation(v[0],v[1],v[2]);}
	 inline	 void setSize(pfVec3 v) { setSize(v[0],v[1],v[2]); }
	protected:
	 virtual void acceptNetKey(const ygString&);
	private:
	 struct _fltTransformPrivateData *p_;
	 void setPosition(const ygMessage&);
	 void setOrientation(const ygMessage&);
	 void setSize(const ygMessage&);
	 void storeMatrixKey(void);
	};

#endif
