// Description: a selector that rotates through the sequence in a fixed duration
//
//<b>notes:</b>
//<ul>
//<li> derived nodes inherit all messages from their base classes
//<li> see reset method for default settings
//<li> this node can also be implemented with a <a href="timer.html">timer</a> node
//</ul>
//
// Category: Selection
// Author: Kyoung Park
// Revision: 11/01/01
//
#include <ygWorld.h>
#include "flipbook.h"

extern "C" ygNode* construct_flipbook(const char* name,bool master) { return new flipbook(name,master); }

flipbook::flipbook(const char* name,bool master) : ygSelector(name,master)
	{
	setClassName("flipbook");
	}

flipbook::~flipbook(void)
	{
	}
	
void flipbook::reset(void)
	{
	//reset first frame flag
	firstFrame_ = true;
	//set duration to 1.0
	duration_ = 1.0;
	//set active to false
	active_ = false;
	startTime_ = 0.0;
	ygSelector::reset();
	}


void flipbook::message(const ygMessage& msg)
	{
	//set the duration of the sequence
	if (msg == "duration")
		{
		duration_ = msg.floatArg(0);
		}
	//set active mode
	else if (msg == "active")
		{
		active_ = msg.boolArg(0);
		}
	//start the sequence
	else if (msg == "start")
		{
		start();
		}
	//stop the sequence
	else if (msg == "stop")
		{
		stop();
		}
	else
		ygSelector::message(msg);
	}

void flipbook::start(void)
	{
	//if not active
	if (!active_)
		{
		//set active to true
		active_ = true;
		//set start time
		startTime_ = ygWorld::FrameTime;
		}
	}

void flipbook::stop(void)
	{
	//if active then set active to false
	if (active_)
		{
		active_ = false;
		}
	}

void flipbook::app(void)
	{
	//if first frame then select first item
	if (firstFrame_)
		{
		select(0);
		firstFrame_ = false;
		}
	//if active
	if (active_) 
		{
		int v, max = numChildren();
		float t;
		//divide elapsed time by duration
		t = (ygWorld::FrameTime - startTime_) / duration_;
		t -= (int) t;
		//convert to integer
		v = (int) (t * max);
		if (v >= max)
			v = max - 1;
		//set selector
		select(v);
		}

	ygSelector::app();
	}
