// Description: a switch that toggles state each frame
//
//<b>notes:</b>
//<ul>
//<li> derived nodes inherit all messages from their base classes
//<li> see reset method for default settings
//</ul>
//
// Category: Selection
// Author: Kyoung Park
// Revision: 11/01/01
//
#include "flicker.h"

extern "C" ygNode* construct_flicker(const char* name,bool master) { return new flicker(name,master); }

struct _flickerPrivateData
	{
	bool active;
	};


flicker::flicker(const char* name,bool master) : ygSwitch(name,master)
	{
	setClassName("flicker");
	p_ = new struct _flickerPrivateData;
	p_->active = false;
	}

flicker::~flicker(void)
	{
	delete p_;
	}


void flicker::reset(void)
	{
	p_->active = false;
	ygSwitch::reset();
	}


void flicker::message(const ygMessage& msg)
	{
	if (msg == "start")
		p_->active = true;
	else if (msg == "stop")
		{
		p_->active = false;
		on();
		}
	else
		ygSwitch::message(msg);
	}


void flicker::app(void)
	{
	if (p_->active)
		toggle();
	ygSwitch::app();
	}
