// Description: sets the transparency of all nodes below it
//
//<b>notes:</b>
//<ul>
//<li> derived nodes inherit all messages from their base classes
//<li> see reset method for default settings
//<li> the transparency of all instanced object nodes will be changed
//<li> use the cache option on child objects in order to avoid unwanted side effects
//<li> an initial message to set the alpha value may be required when using a timer
//</ul>
//
// Category: Attributes
// Author: Alex Hill
// Revision: 11/01/01
//
#include <Performer/pf/pfChannel.h>
#include <Performer/pr/pfMaterial.h>
#include <Performer/pr/pfGeoState.h>
#include <Performer/pr/pfGeoSet.h>
#include <Performer/pf/pfGeode.h>
#include <Performer/pr/pfList.h>
#include <ygNetKeys.h>
#include <ygWorld.h>
#include "fader.h"

using namespace std;

extern "C" ygNode* construct_fader(const char* name,bool master) { return new fader(name,master); }

struct _listEntry
	{
	int num;
	pfVec4 *colors;
	};

static int materialAlreadyInList(pfMaterial *mtl, pfList *matList)
	{
	for (int i = 0; i < matList->getNum(); i++) 
		{
		pfMaterial *m = (pfMaterial *) matList->get(i);
		if (m == mtl)
			return 1;
		}
	return 0;
	}

static void getColorsAndMaterials(pfNode *node, pfList *colorList, pfList *matList)
	{
	int i;
	if (node->isOfType(pfGeode::getClassType())) 
		{
		pfGeode *geode = (pfGeode *)node;
		for (i = 0; i < geode->getNumGSets(); i++) 
			{
			ushort *ilist;
			pfGeoSet *gset = geode->getGSet(i);
			if (gset->getAttrRange(PFGS_COLOR4, NULL, NULL)) 
				{
				struct _listEntry *e = (struct _listEntry *)pfMalloc(sizeof(struct _listEntry), pfGetSharedArena());
				e->num = gset->getAttrRange(PFGS_COLOR4, NULL, NULL);
				gset->getAttrLists(PFGS_COLOR4, (void **)&(e->colors), &ilist);
				colorList->add((void *) e);
				}
			pfMaterial *mtl = (pfMaterial *)gset->getGState()->getAttr(PFSTATE_FRONTMTL);
			if (!materialAlreadyInList(mtl, matList))
				matList->add(mtl);
			gset->getGState()->setMode(PFSTATE_TRANSPARENCY, PFTR_BLEND_ALPHA);
			gset->setDrawBin(PFSORT_TRANSP_BIN);
			}	
		}
	else if (node->isOfType(pfGroup::getClassType())) 
		{
		pfGroup *group = (pfGroup *)node;
		for (i = 0; i < group->getNumChildren(); i++)
			getColorsAndMaterials(group->getChild(i), colorList, matList);
		}
	}

fader::fader(const char* name,bool master) : ygNode(name,master)
	{
	setClassName("fader",true);
	alpha_ = 1.0;
	colors_ = new pfList;
	materials_ = new pfList;
    addNetKey("alpha",&alpha_,YG_NET_FLOAT);
	}

void fader::reset(void)
	{
	//reset alpha to one
	alpha_ = 1.0;
	netKeyChanged("alpha");
	ygNode::reset();
	}


void fader::message(const ygMessage& msg)
	{
	//set the alpha value
	if (msg == "set" || msg == "value" || msg == "alpha" || msg == "position") 
		{
		alpha_ = msg.floatArg(0);
		if (alpha_ > 1.0 )
			alpha_ = 1.0;
		else if (alpha_ < 0.0)
			alpha_ = 0.0;
		netKeyChanged("alpha");
		}
	else
		ygNode::message(msg);
	}

void fader::app(void)
	{
	//if first frame then get colors and materials
	if (pfChanged()) 
		{
		colors_->reset();
		materials_->reset();
		getColorsAndMaterials(pfnode(), colors_, materials_);
		}
	int i,j;
	//for each color list entry
	for (i = 0; i < colors_->getNum(); i++) 
		{
		struct _listEntry *e = (struct _listEntry *) colors_->get(i);
		//set each color alpha value
		for (j = 0; j < e->num; j++) 
			{
			e->colors[j][3] = alpha_;
			}
		}
	//for each material set the alpha value
	for (i = 0; i < materials_->getNum(); i++) 
		{
		((pfMaterial *) materials_->get(i))->setAlpha(alpha_);
		}
	ygNode::app();
	}
