// Description: fades out all nodes below it over a duration
//
//<b>notes:</b>
//<ul>
//<li> derived nodes inherit all messages from their base classes
//<li> see reset method for default settings
//<li> the transparency of all instanced object nodes will be changed
//<li> use the cache option on child objects in order to avoid unwanted side effects
//<li> this node can also be implemented with a <a href="fader.html">fader</a> node and a <a href="timer.html">timer</a>
//</ul>
//
// Category: Deprecated
// Author: Kyoung Park
// Revision: 11/01/01
//
#include <Performer/pf/pfChannel.h>
#include <Performer/pr/pfMaterial.h>
#include <Performer/pr/pfGeoState.h>
#include <Performer/pr/pfGeoSet.h>
#include <Performer/pf/pfGeode.h>
#include <Performer/pr/pfList.h>
#include "ygWorld.h"
#include "fadeOut.h"

using namespace std;

extern "C" ygNode* construct_fadeOut(const char* name,bool master) { return new fadeOut(name,master); }

struct _listEntry
{
	int num;
	pfVec4 *colors;
};

static int materialAlreadyInList(pfMaterial *mtl, pfList *matList)
{
	for (int i = 0; i < matList->getNum(); i++) {
		pfMaterial *m = (pfMaterial *) matList->get(i);
		if (m == mtl)
			return 1;
	}
	return 0;
}

static void getColorsAndMaterials(pfNode *node, pfList *colorList, pfList *matList)
{
	int i;
	if (node->isOfType(pfGeode::getClassType())) {
		pfGeode *geode = (pfGeode *)node;
		for (i = 0; i < geode->getNumGSets(); i++) {
			ushort *ilist;
			pfGeoSet *gset = geode->getGSet(i);
			if (gset->getAttrRange(PFGS_COLOR4, NULL, NULL)) {
				struct _listEntry *e = (struct _listEntry *)pfMalloc(sizeof(struct _listEntry), pfGetSharedArena());
				e->num = gset->getAttrRange(PFGS_COLOR4, NULL, NULL);
				gset->getAttrLists(PFGS_COLOR4, (void **)&(e->colors), &ilist);
				colorList->add((void *) e);
			}
			pfMaterial *mtl = (pfMaterial *)gset->getGState()->getAttr(PFSTATE_FRONTMTL);
			if (!materialAlreadyInList(mtl, matList))
				matList->add(mtl);
			gset->getGState()->setMode(PFSTATE_TRANSPARENCY, PFTR_BLEND_ALPHA);
			gset->setDrawBin(PFSORT_TRANSP_BIN);
		}	
	}
	else if (node->isOfType(pfGroup::getClassType())) {
		pfGroup *group = (pfGroup *)node;
		for (i = 0; i < group->getNumChildren(); i++)
			getColorsAndMaterials(group->getChild(i), colorList, matList);
	}
}

fadeOut::fadeOut(const char* name,bool master) : ygNode(name,master)
{
	setClassName("fadeOut");

	colors_ = new pfList;
	materials_ = new pfList;

	//set active to false
	active_ = false;
	initActive_ = true;
	firstFrame_ = true;

	//set duration to 1.0 seconds
	duration_ = 1.0;
	//set starting alpha to 1.0
	startalpha_ = 1.0;
	//set ending alpha to 0.0
	endalpha_ = 0.0;
	//set mode to one time
	mode_ = ONETIME;
}

void fadeOut::reset(void)
{
	active_ = false;
	initActive_ = true;
	firstFrame_ = true;

	duration_ = 1.0;
	startalpha_ = 1.0;
	endalpha_ = 0.0;
	mode_ = ONETIME;

	ygNode::reset();
}


void fadeOut::message(const ygMessage& msg)
{
	//set starting alpha value
	if (msg == "startalpha") {
		startalpha_ = msg.floatArg(0);
	}
	//set ending alpha value
	else if (msg == "endalpha") {
		endalpha_ = msg.floatArg(0);
	}
	//set fade duration
	else if (msg == "duration") {
		duration_ = msg.floatArg(0);
	}
	//reset to default values
	else if (msg == "reset") {
		reset();
	}
	//set mode
	else if (msg == "mode") {
		if (msg.args[0] == "once")
			mode_ = ONETIME;
		else if (msg.args[0] == "cycle")
			mode_ = CYCLE;
		else if (msg.args[0] == "swing")
			mode_ = SWING;
	}
	//set active mode
	else if (msg == "active") {
		initActive_ = msg.boolArg(0);
	}
	//start fade
	else if (msg == "start") {
		start();
	}
	//stop fade
	else if (msg == "stop") {
		stop();
	}
	else
		ygNode::message(msg);
}

void fadeOut::start(void)
{
	if (!active_) {
		active_ = true;
		startTime_ = ygWorld::FrameTime;
	}
}

void fadeOut::stop(void)
{
	active_ = false;
}

float fadeOut::alphavalue(void)
{
	if (fabs(duration_) < 0.000001f)
                return endalpha_;

        float t = ygWorld::FrameTime - startTime_;

        if (mode_ == ONETIME)
        {
                if (t > duration_)
                        return endalpha_;
        }
        else if (mode_ == CYCLE)
        {
                t = fmod(t,duration_);
        }
        else if (mode_ == SWING)
        {
                t = fmod(t,duration_*2.0f);
                if (t > duration_)
                        t = duration_*2.0f - t;
        }

        return (startalpha_ - endalpha_) - (startalpha_ - endalpha_) * t / duration_;
}

void fadeOut::app(void)
{
	if (firstFrame_) {
		getColorsAndMaterials(pfnode(), colors_, materials_);
		if (initActive_) start();
		firstFrame_ = false;
	}

	if (active_) {
		int i,j;
		for (i = 0; i < colors_->getNum(); i++) {
			struct _listEntry *e = (struct _listEntry *) colors_->get(i);
			for (j = 0; j < e->num; j++) {
				e->colors[j][3] = alphavalue();
			}
		}

		for (i = 0; i < materials_->getNum(); i++) {
			((pfMaterial *) materials_->get(i))->setAlpha(alphavalue());
		}
	}

	ygNode::app();
}
